/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkGroupProperties;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class NetworkGroupInner
extends ChildResource {
    private NetworkGroupProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;
    private String etag;

    private NetworkGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NetworkGroupInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkGroupProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkGroupInner)((Object)jsonReader.readObject(reader -> {
            NetworkGroupInner deserializedNetworkGroupInner = new NetworkGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkGroupInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkGroupInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkGroupInner.innerProperties = NetworkGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetworkGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkGroupInner;
        }));
    }
}

