/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FlowLogProperties;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import java.io.IOException;

public final class FlowLogInformationInner
implements JsonSerializable<FlowLogInformationInner> {
    private String targetResourceId;
    private FlowLogProperties innerProperties = new FlowLogProperties();
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;
    private ManagedServiceIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(FlowLogInformationInner.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogInformationInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    private FlowLogProperties innerProperties() {
        return this.innerProperties;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogInformationInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public FlowLogInformationInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String storageId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageId();
    }

    public FlowLogInformationInner withStorageId(String storageId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withStorageId(storageId);
        return this;
    }

    public boolean enabled() {
        return this.innerProperties() == null ? false : this.innerProperties().enabled();
    }

    public FlowLogInformationInner withEnabled(boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    public FlowLogInformationInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public FlowLogInformationInner withFormat(FlowLogFormatParameters format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model FlowLogInformationInner"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model FlowLogInformationInner"));
        }
        this.innerProperties().validate();
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("flowAnalyticsConfiguration", (JsonSerializable)this.flowAnalyticsConfiguration);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static FlowLogInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (FlowLogInformationInner)jsonReader.readObject(reader -> {
            FlowLogInformationInner deserializedFlowLogInformationInner = new FlowLogInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedFlowLogInformationInner.targetResourceId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFlowLogInformationInner.innerProperties = FlowLogProperties.fromJson(reader);
                    continue;
                }
                if ("flowAnalyticsConfiguration".equals(fieldName)) {
                    deserializedFlowLogInformationInner.flowAnalyticsConfiguration = TrafficAnalyticsProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFlowLogInformationInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowLogInformationInner;
        });
    }
}

