/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRouteCrossConnectionInner
extends Resource {
    private ExpressRouteCrossConnectionProperties innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    private ExpressRouteCrossConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteCrossConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ExpressRouteCrossConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteCrossConnectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    public Integer stag() {
        return this.innerProperties() == null ? null : this.innerProperties().stag();
    }

    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    public Integer bandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthInMbps();
    }

    public ExpressRouteCircuitReference expressRouteCircuit() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteCircuit();
    }

    public ExpressRouteCrossConnectionInner withExpressRouteCircuit(ExpressRouteCircuitReference expressRouteCircuit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withExpressRouteCircuit(expressRouteCircuit);
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderProvisioningState();
    }

    public ExpressRouteCrossConnectionInner withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withServiceProviderProvisioningState(serviceProviderProvisioningState);
        return this;
    }

    public String serviceProviderNotes() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderNotes();
    }

    public ExpressRouteCrossConnectionInner withServiceProviderNotes(String serviceProviderNotes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withServiceProviderNotes(serviceProviderNotes);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ExpressRouteCrossConnectionPeeringInner> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public ExpressRouteCrossConnectionInner withPeerings(List<ExpressRouteCrossConnectionPeeringInner> peerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withPeerings(peerings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCrossConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCrossConnectionInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionInner deserializedExpressRouteCrossConnectionInner = new ExpressRouteCrossConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteCrossConnectionInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.innerProperties = ExpressRouteCrossConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCrossConnectionInner;
        }));
    }
}

