/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitAuthorizationInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPropertiesFormat;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitServiceProviderProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitSku;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRouteCircuitInner
extends Resource {
    private ExpressRouteCircuitSku sku;
    private ExpressRouteCircuitPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    public ExpressRouteCircuitSku sku() {
        return this.sku;
    }

    public ExpressRouteCircuitInner withSku(ExpressRouteCircuitSku sku) {
        this.sku = sku;
        return this;
    }

    private ExpressRouteCircuitPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteCircuitInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ExpressRouteCircuitInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteCircuitInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean allowClassicOperations() {
        return this.innerProperties() == null ? null : this.innerProperties().allowClassicOperations();
    }

    public ExpressRouteCircuitInner withAllowClassicOperations(Boolean allowClassicOperations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withAllowClassicOperations(allowClassicOperations);
        return this;
    }

    public String circuitProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitProvisioningState();
    }

    public ExpressRouteCircuitInner withCircuitProvisioningState(String circuitProvisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withCircuitProvisioningState(circuitProvisioningState);
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderProvisioningState();
    }

    public ExpressRouteCircuitInner withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withServiceProviderProvisioningState(serviceProviderProvisioningState);
        return this;
    }

    public List<ExpressRouteCircuitAuthorizationInner> authorizations() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizations();
    }

    public ExpressRouteCircuitInner withAuthorizations(List<ExpressRouteCircuitAuthorizationInner> authorizations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withAuthorizations(authorizations);
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public ExpressRouteCircuitInner withPeerings(List<ExpressRouteCircuitPeeringInner> peerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withPeerings(peerings);
        return this;
    }

    public String serviceKey() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceKey();
    }

    public ExpressRouteCircuitInner withServiceKey(String serviceKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withServiceKey(serviceKey);
        return this;
    }

    public String serviceProviderNotes() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderNotes();
    }

    public ExpressRouteCircuitInner withServiceProviderNotes(String serviceProviderNotes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withServiceProviderNotes(serviceProviderNotes);
        return this;
    }

    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderProperties();
    }

    public ExpressRouteCircuitInner withServiceProviderProperties(ExpressRouteCircuitServiceProviderProperties serviceProviderProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withServiceProviderProperties(serviceProviderProperties);
        return this;
    }

    public SubResource expressRoutePort() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRoutePort();
    }

    public ExpressRouteCircuitInner withExpressRoutePort(SubResource expressRoutePort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withExpressRoutePort(expressRoutePort);
        return this;
    }

    public Float bandwidthInGbps() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthInGbps();
    }

    public ExpressRouteCircuitInner withBandwidthInGbps(Float bandwidthInGbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withBandwidthInGbps(bandwidthInGbps);
        return this;
    }

    public Integer stag() {
        return this.innerProperties() == null ? null : this.innerProperties().stag();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String gatewayManagerEtag() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayManagerEtag();
    }

    public ExpressRouteCircuitInner withGatewayManagerEtag(String gatewayManagerEtag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withGatewayManagerEtag(gatewayManagerEtag);
        return this;
    }

    public Boolean globalReachEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().globalReachEnabled();
    }

    public ExpressRouteCircuitInner withGlobalReachEnabled(Boolean globalReachEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withGlobalReachEnabled(globalReachEnabled);
        return this;
    }

    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    public ExpressRouteCircuitInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    public String authorizationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationStatus();
    }

    public Boolean enableDirectPortRateLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDirectPortRateLimit();
    }

    public ExpressRouteCircuitInner withEnableDirectPortRateLimit(Boolean enableDirectPortRateLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPropertiesFormat();
        }
        this.innerProperties().withEnableDirectPortRateLimit(enableDirectPortRateLimit);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteCircuitInner deserializedExpressRouteCircuitInner = new ExpressRouteCircuitInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteCircuitInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.sku = ExpressRouteCircuitSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.innerProperties = ExpressRouteCircuitPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCircuitInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitInner;
        }));
    }
}

