/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.DscpConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosDefinition;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DscpConfigurationInner
extends Resource {
    private DscpConfigurationPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    private DscpConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public DscpConfigurationInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public DscpConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DscpConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<Integer> markings() {
        return this.innerProperties() == null ? null : this.innerProperties().markings();
    }

    public DscpConfigurationInner withMarkings(List<Integer> markings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withMarkings(markings);
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceIpRanges();
    }

    public DscpConfigurationInner withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withSourceIpRanges(sourceIpRanges);
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationIpRanges();
    }

    public DscpConfigurationInner withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withDestinationIpRanges(destinationIpRanges);
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public DscpConfigurationInner withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public DscpConfigurationInner withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public ProtocolType protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public DscpConfigurationInner withProtocol(ProtocolType protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public List<QosDefinition> qosDefinitionCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().qosDefinitionCollection();
    }

    public DscpConfigurationInner withQosDefinitionCollection(List<QosDefinition> qosDefinitionCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscpConfigurationPropertiesFormat();
        }
        this.innerProperties().withQosDefinitionCollection(qosDefinitionCollection);
        return this;
    }

    public String qosCollectionId() {
        return this.innerProperties() == null ? null : this.innerProperties().qosCollectionId();
    }

    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedNetworkInterfaces();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static DscpConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscpConfigurationInner)((Object)jsonReader.readObject(reader -> {
            DscpConfigurationInner deserializedDscpConfigurationInner = new DscpConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDscpConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscpConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDscpConfigurationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDscpConfigurationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscpConfigurationInner.innerProperties = DscpConfigurationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDscpConfigurationInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDscpConfigurationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscpConfigurationInner;
        }));
    }
}

