/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.CustomIpPrefixPropertiesFormat;
import com.azure.resourcemanager.network.models.CommissionedState;
import com.azure.resourcemanager.network.models.CustomIpPrefixType;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.Geo;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CustomIpPrefixInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private CustomIpPrefixPropertiesFormat innerProperties;
    private String etag;
    private List<String> zones;
    private String id;
    private String name;
    private String type;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public CustomIpPrefixInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private CustomIpPrefixPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CustomIpPrefixInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String id() {
        return this.id;
    }

    public CustomIpPrefixInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public CustomIpPrefixInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CustomIpPrefixInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String asn() {
        return this.innerProperties() == null ? null : this.innerProperties().asn();
    }

    public CustomIpPrefixInner withAsn(String asn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withAsn(asn);
        return this;
    }

    public String cidr() {
        return this.innerProperties() == null ? null : this.innerProperties().cidr();
    }

    public CustomIpPrefixInner withCidr(String cidr) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withCidr(cidr);
        return this;
    }

    public String signedMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().signedMessage();
    }

    public CustomIpPrefixInner withSignedMessage(String signedMessage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withSignedMessage(signedMessage);
        return this;
    }

    public String authorizationMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationMessage();
    }

    public CustomIpPrefixInner withAuthorizationMessage(String authorizationMessage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withAuthorizationMessage(authorizationMessage);
        return this;
    }

    public SubResource customIpPrefixParent() {
        return this.innerProperties() == null ? null : this.innerProperties().customIpPrefixParent();
    }

    public CustomIpPrefixInner withCustomIpPrefixParent(SubResource customIpPrefixParent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withCustomIpPrefixParent(customIpPrefixParent);
        return this;
    }

    public List<SubResource> childCustomIpPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().childCustomIpPrefixes();
    }

    public CommissionedState commissionedState() {
        return this.innerProperties() == null ? null : this.innerProperties().commissionedState();
    }

    public CustomIpPrefixInner withCommissionedState(CommissionedState commissionedState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withCommissionedState(commissionedState);
        return this;
    }

    public Boolean expressRouteAdvertise() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteAdvertise();
    }

    public CustomIpPrefixInner withExpressRouteAdvertise(Boolean expressRouteAdvertise) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withExpressRouteAdvertise(expressRouteAdvertise);
        return this;
    }

    public Geo geo() {
        return this.innerProperties() == null ? null : this.innerProperties().geo();
    }

    public CustomIpPrefixInner withGeo(Geo geo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withGeo(geo);
        return this;
    }

    public Boolean noInternetAdvertise() {
        return this.innerProperties() == null ? null : this.innerProperties().noInternetAdvertise();
    }

    public CustomIpPrefixInner withNoInternetAdvertise(Boolean noInternetAdvertise) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withNoInternetAdvertise(noInternetAdvertise);
        return this;
    }

    public CustomIpPrefixType prefixType() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixType();
    }

    public CustomIpPrefixInner withPrefixType(CustomIpPrefixType prefixType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomIpPrefixPropertiesFormat();
        }
        this.innerProperties().withPrefixType(prefixType);
        return this;
    }

    public List<SubResource> publicIpPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefixes();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public String failedReason() {
        return this.innerProperties() == null ? null : this.innerProperties().failedReason();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static CustomIpPrefixInner fromJson(JsonReader jsonReader) throws IOException {
        return (CustomIpPrefixInner)((Object)jsonReader.readObject(reader -> {
            CustomIpPrefixInner deserializedCustomIpPrefixInner = new CustomIpPrefixInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCustomIpPrefixInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.innerProperties = CustomIpPrefixPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.etag = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedCustomIpPrefixInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedCustomIpPrefixInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomIpPrefixInner;
        }));
    }
}

