/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallFqdnTagPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class AzureFirewallFqdnTagInner
extends Resource {
    private AzureFirewallFqdnTagPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    private AzureFirewallFqdnTagPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public AzureFirewallFqdnTagInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AzureFirewallFqdnTagInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AzureFirewallFqdnTagInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String fqdnTagName() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdnTagName();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallFqdnTagInner fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallFqdnTagInner)((Object)jsonReader.readObject(reader -> {
            AzureFirewallFqdnTagInner deserializedAzureFirewallFqdnTagInner = new AzureFirewallFqdnTagInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAzureFirewallFqdnTagInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.innerProperties = AzureFirewallFqdnTagPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallFqdnTagInner;
        }));
    }
}

