// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * VpnClientConnectionHealth properties.
 */
@Fluent
public final class VpnClientConnectionHealth implements JsonSerializable<VpnClientConnectionHealth> {
    /*
     * Total of the Ingress Bytes Transferred in this P2S Vpn connection.
     */
    private Long totalIngressBytesTransferred;

    /*
     * Total of the Egress Bytes Transferred in this connection.
     */
    private Long totalEgressBytesTransferred;

    /*
     * The total of p2s vpn clients connected at this time to this P2SVpnGateway.
     */
    private Integer vpnClientConnectionsCount;

    /*
     * List of allocated ip addresses to the connected p2s vpn clients.
     */
    private List<String> allocatedIpAddresses;

    /**
     * Creates an instance of VpnClientConnectionHealth class.
     */
    public VpnClientConnectionHealth() {
    }

    /**
     * Get the totalIngressBytesTransferred property: Total of the Ingress Bytes Transferred in this P2S Vpn connection.
     * 
     * @return the totalIngressBytesTransferred value.
     */
    public Long totalIngressBytesTransferred() {
        return this.totalIngressBytesTransferred;
    }

    /**
     * Get the totalEgressBytesTransferred property: Total of the Egress Bytes Transferred in this connection.
     * 
     * @return the totalEgressBytesTransferred value.
     */
    public Long totalEgressBytesTransferred() {
        return this.totalEgressBytesTransferred;
    }

    /**
     * Get the vpnClientConnectionsCount property: The total of p2s vpn clients connected at this time to this
     * P2SVpnGateway.
     * 
     * @return the vpnClientConnectionsCount value.
     */
    public Integer vpnClientConnectionsCount() {
        return this.vpnClientConnectionsCount;
    }

    /**
     * Set the vpnClientConnectionsCount property: The total of p2s vpn clients connected at this time to this
     * P2SVpnGateway.
     * 
     * @param vpnClientConnectionsCount the vpnClientConnectionsCount value to set.
     * @return the VpnClientConnectionHealth object itself.
     */
    public VpnClientConnectionHealth withVpnClientConnectionsCount(Integer vpnClientConnectionsCount) {
        this.vpnClientConnectionsCount = vpnClientConnectionsCount;
        return this;
    }

    /**
     * Get the allocatedIpAddresses property: List of allocated ip addresses to the connected p2s vpn clients.
     * 
     * @return the allocatedIpAddresses value.
     */
    public List<String> allocatedIpAddresses() {
        return this.allocatedIpAddresses;
    }

    /**
     * Set the allocatedIpAddresses property: List of allocated ip addresses to the connected p2s vpn clients.
     * 
     * @param allocatedIpAddresses the allocatedIpAddresses value to set.
     * @return the VpnClientConnectionHealth object itself.
     */
    public VpnClientConnectionHealth withAllocatedIpAddresses(List<String> allocatedIpAddresses) {
        this.allocatedIpAddresses = allocatedIpAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("vpnClientConnectionsCount", this.vpnClientConnectionsCount);
        jsonWriter.writeArrayField("allocatedIpAddresses", this.allocatedIpAddresses,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnClientConnectionHealth from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnClientConnectionHealth if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnClientConnectionHealth.
     */
    public static VpnClientConnectionHealth fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnClientConnectionHealth deserializedVpnClientConnectionHealth = new VpnClientConnectionHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("totalIngressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.totalIngressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("totalEgressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.totalEgressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("vpnClientConnectionsCount".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.vpnClientConnectionsCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("allocatedIpAddresses".equals(fieldName)) {
                    List<String> allocatedIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedVpnClientConnectionHealth.allocatedIpAddresses = allocatedIpAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnClientConnectionHealth;
        });
    }
}
