// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An traffic selector policy for a virtual network gateway connection.
 */
@Fluent
public final class TrafficSelectorPolicy implements JsonSerializable<TrafficSelectorPolicy> {
    /*
     * A collection of local address spaces in CIDR format.
     */
    private List<String> localAddressRanges;

    /*
     * A collection of remote address spaces in CIDR format.
     */
    private List<String> remoteAddressRanges;

    /**
     * Creates an instance of TrafficSelectorPolicy class.
     */
    public TrafficSelectorPolicy() {
    }

    /**
     * Get the localAddressRanges property: A collection of local address spaces in CIDR format.
     * 
     * @return the localAddressRanges value.
     */
    public List<String> localAddressRanges() {
        return this.localAddressRanges;
    }

    /**
     * Set the localAddressRanges property: A collection of local address spaces in CIDR format.
     * 
     * @param localAddressRanges the localAddressRanges value to set.
     * @return the TrafficSelectorPolicy object itself.
     */
    public TrafficSelectorPolicy withLocalAddressRanges(List<String> localAddressRanges) {
        this.localAddressRanges = localAddressRanges;
        return this;
    }

    /**
     * Get the remoteAddressRanges property: A collection of remote address spaces in CIDR format.
     * 
     * @return the remoteAddressRanges value.
     */
    public List<String> remoteAddressRanges() {
        return this.remoteAddressRanges;
    }

    /**
     * Set the remoteAddressRanges property: A collection of remote address spaces in CIDR format.
     * 
     * @param remoteAddressRanges the remoteAddressRanges value to set.
     * @return the TrafficSelectorPolicy object itself.
     */
    public TrafficSelectorPolicy withRemoteAddressRanges(List<String> remoteAddressRanges) {
        this.remoteAddressRanges = remoteAddressRanges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (localAddressRanges() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property localAddressRanges in model TrafficSelectorPolicy"));
        }
        if (remoteAddressRanges() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property remoteAddressRanges in model TrafficSelectorPolicy"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TrafficSelectorPolicy.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("localAddressRanges", this.localAddressRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("remoteAddressRanges", this.remoteAddressRanges,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrafficSelectorPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrafficSelectorPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TrafficSelectorPolicy.
     */
    public static TrafficSelectorPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrafficSelectorPolicy deserializedTrafficSelectorPolicy = new TrafficSelectorPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localAddressRanges".equals(fieldName)) {
                    List<String> localAddressRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedTrafficSelectorPolicy.localAddressRanges = localAddressRanges;
                } else if ("remoteAddressRanges".equals(fieldName)) {
                    List<String> remoteAddressRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedTrafficSelectorPolicy.remoteAddressRanges = remoteAddressRanges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrafficSelectorPolicy;
        });
    }
}
