// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Routing Configuration indicating the associated and propagated route tables for this connection.
 */
@Fluent
public final class RoutingConfiguration implements JsonSerializable<RoutingConfiguration> {
    /*
     * The resource id RouteTable associated with this RoutingConfiguration.
     */
    private SubResource associatedRouteTable;

    /*
     * The list of RouteTables to advertise the routes to.
     */
    private PropagatedRouteTable propagatedRouteTables;

    /*
     * List of routes that control routing from VirtualHub into a virtual network connection.
     */
    private VnetRoute vnetRoutes;

    /*
     * The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
     */
    private SubResource inboundRouteMap;

    /*
     * The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
     */
    private SubResource outboundRouteMap;

    /**
     * Creates an instance of RoutingConfiguration class.
     */
    public RoutingConfiguration() {
    }

    /**
     * Get the associatedRouteTable property: The resource id RouteTable associated with this RoutingConfiguration.
     * 
     * @return the associatedRouteTable value.
     */
    public SubResource associatedRouteTable() {
        return this.associatedRouteTable;
    }

    /**
     * Set the associatedRouteTable property: The resource id RouteTable associated with this RoutingConfiguration.
     * 
     * @param associatedRouteTable the associatedRouteTable value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withAssociatedRouteTable(SubResource associatedRouteTable) {
        this.associatedRouteTable = associatedRouteTable;
        return this;
    }

    /**
     * Get the propagatedRouteTables property: The list of RouteTables to advertise the routes to.
     * 
     * @return the propagatedRouteTables value.
     */
    public PropagatedRouteTable propagatedRouteTables() {
        return this.propagatedRouteTables;
    }

    /**
     * Set the propagatedRouteTables property: The list of RouteTables to advertise the routes to.
     * 
     * @param propagatedRouteTables the propagatedRouteTables value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withPropagatedRouteTables(PropagatedRouteTable propagatedRouteTables) {
        this.propagatedRouteTables = propagatedRouteTables;
        return this;
    }

    /**
     * Get the vnetRoutes property: List of routes that control routing from VirtualHub into a virtual network
     * connection.
     * 
     * @return the vnetRoutes value.
     */
    public VnetRoute vnetRoutes() {
        return this.vnetRoutes;
    }

    /**
     * Set the vnetRoutes property: List of routes that control routing from VirtualHub into a virtual network
     * connection.
     * 
     * @param vnetRoutes the vnetRoutes value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withVnetRoutes(VnetRoute vnetRoutes) {
        this.vnetRoutes = vnetRoutes;
        return this;
    }

    /**
     * Get the inboundRouteMap property: The resource id of the RouteMap associated with this RoutingConfiguration for
     * inbound learned routes.
     * 
     * @return the inboundRouteMap value.
     */
    public SubResource inboundRouteMap() {
        return this.inboundRouteMap;
    }

    /**
     * Set the inboundRouteMap property: The resource id of the RouteMap associated with this RoutingConfiguration for
     * inbound learned routes.
     * 
     * @param inboundRouteMap the inboundRouteMap value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withInboundRouteMap(SubResource inboundRouteMap) {
        this.inboundRouteMap = inboundRouteMap;
        return this;
    }

    /**
     * Get the outboundRouteMap property: The resource id of theRouteMap associated with this RoutingConfiguration for
     * outbound advertised routes.
     * 
     * @return the outboundRouteMap value.
     */
    public SubResource outboundRouteMap() {
        return this.outboundRouteMap;
    }

    /**
     * Set the outboundRouteMap property: The resource id of theRouteMap associated with this RoutingConfiguration for
     * outbound advertised routes.
     * 
     * @param outboundRouteMap the outboundRouteMap value to set.
     * @return the RoutingConfiguration object itself.
     */
    public RoutingConfiguration withOutboundRouteMap(SubResource outboundRouteMap) {
        this.outboundRouteMap = outboundRouteMap;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (propagatedRouteTables() != null) {
            propagatedRouteTables().validate();
        }
        if (vnetRoutes() != null) {
            vnetRoutes().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("associatedRouteTable", this.associatedRouteTable);
        jsonWriter.writeJsonField("propagatedRouteTables", this.propagatedRouteTables);
        jsonWriter.writeJsonField("vnetRoutes", this.vnetRoutes);
        jsonWriter.writeJsonField("inboundRouteMap", this.inboundRouteMap);
        jsonWriter.writeJsonField("outboundRouteMap", this.outboundRouteMap);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoutingConfiguration.
     */
    public static RoutingConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingConfiguration deserializedRoutingConfiguration = new RoutingConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("associatedRouteTable".equals(fieldName)) {
                    deserializedRoutingConfiguration.associatedRouteTable = SubResource.fromJson(reader);
                } else if ("propagatedRouteTables".equals(fieldName)) {
                    deserializedRoutingConfiguration.propagatedRouteTables = PropagatedRouteTable.fromJson(reader);
                } else if ("vnetRoutes".equals(fieldName)) {
                    deserializedRoutingConfiguration.vnetRoutes = VnetRoute.fromJson(reader);
                } else if ("inboundRouteMap".equals(fieldName)) {
                    deserializedRoutingConfiguration.inboundRouteMap = SubResource.fromJson(reader);
                } else if ("outboundRouteMap".equals(fieldName)) {
                    deserializedRoutingConfiguration.outboundRouteMap = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingConfiguration;
        });
    }
}
