// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * To scrub sensitive log fields.
 */
@Fluent
public final class PolicySettingsLogScrubbing implements JsonSerializable<PolicySettingsLogScrubbing> {
    /*
     * State of the log scrubbing config. Default value is Enabled.
     */
    private WebApplicationFirewallScrubbingState state;

    /*
     * The rules that are applied to the logs for scrubbing.
     */
    private List<WebApplicationFirewallScrubbingRules> scrubbingRules;

    /**
     * Creates an instance of PolicySettingsLogScrubbing class.
     */
    public PolicySettingsLogScrubbing() {
    }

    /**
     * Get the state property: State of the log scrubbing config. Default value is Enabled.
     * 
     * @return the state value.
     */
    public WebApplicationFirewallScrubbingState state() {
        return this.state;
    }

    /**
     * Set the state property: State of the log scrubbing config. Default value is Enabled.
     * 
     * @param state the state value to set.
     * @return the PolicySettingsLogScrubbing object itself.
     */
    public PolicySettingsLogScrubbing withState(WebApplicationFirewallScrubbingState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the scrubbingRules property: The rules that are applied to the logs for scrubbing.
     * 
     * @return the scrubbingRules value.
     */
    public List<WebApplicationFirewallScrubbingRules> scrubbingRules() {
        return this.scrubbingRules;
    }

    /**
     * Set the scrubbingRules property: The rules that are applied to the logs for scrubbing.
     * 
     * @param scrubbingRules the scrubbingRules value to set.
     * @return the PolicySettingsLogScrubbing object itself.
     */
    public PolicySettingsLogScrubbing withScrubbingRules(List<WebApplicationFirewallScrubbingRules> scrubbingRules) {
        this.scrubbingRules = scrubbingRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scrubbingRules() != null) {
            scrubbingRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("scrubbingRules", this.scrubbingRules,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicySettingsLogScrubbing from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicySettingsLogScrubbing if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicySettingsLogScrubbing.
     */
    public static PolicySettingsLogScrubbing fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicySettingsLogScrubbing deserializedPolicySettingsLogScrubbing = new PolicySettingsLogScrubbing();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedPolicySettingsLogScrubbing.state
                        = WebApplicationFirewallScrubbingState.fromString(reader.getString());
                } else if ("scrubbingRules".equals(fieldName)) {
                    List<WebApplicationFirewallScrubbingRules> scrubbingRules
                        = reader.readArray(reader1 -> WebApplicationFirewallScrubbingRules.fromJson(reader1));
                    deserializedPolicySettingsLogScrubbing.scrubbingRules = scrubbingRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicySettingsLogScrubbing;
        });
    }
}
