// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters that define the source and destination endpoint.
 */
@Fluent
public final class NextHopParameters implements JsonSerializable<NextHopParameters> {
    /*
     * The resource identifier of the target resource against which the action is to be performed.
     */
    private String targetResourceId;

    /*
     * The source IP address.
     */
    private String sourceIpAddress;

    /*
     * The destination IP address.
     */
    private String destinationIpAddress;

    /*
     * The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be
     * specified. Otherwise optional).
     */
    private String targetNicResourceId;

    /**
     * Creates an instance of NextHopParameters class.
     */
    public NextHopParameters() {
    }

    /**
     * Get the targetResourceId property: The resource identifier of the target resource against which the action is to
     * be performed.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: The resource identifier of the target resource against which the action is to
     * be performed.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the NextHopParameters object itself.
     */
    public NextHopParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get the sourceIpAddress property: The source IP address.
     * 
     * @return the sourceIpAddress value.
     */
    public String sourceIpAddress() {
        return this.sourceIpAddress;
    }

    /**
     * Set the sourceIpAddress property: The source IP address.
     * 
     * @param sourceIpAddress the sourceIpAddress value to set.
     * @return the NextHopParameters object itself.
     */
    public NextHopParameters withSourceIpAddress(String sourceIpAddress) {
        this.sourceIpAddress = sourceIpAddress;
        return this;
    }

    /**
     * Get the destinationIpAddress property: The destination IP address.
     * 
     * @return the destinationIpAddress value.
     */
    public String destinationIpAddress() {
        return this.destinationIpAddress;
    }

    /**
     * Set the destinationIpAddress property: The destination IP address.
     * 
     * @param destinationIpAddress the destinationIpAddress value to set.
     * @return the NextHopParameters object itself.
     */
    public NextHopParameters withDestinationIpAddress(String destinationIpAddress) {
        this.destinationIpAddress = destinationIpAddress;
        return this;
    }

    /**
     * Get the targetNicResourceId property: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of
     * the nics, then this parameter must be specified. Otherwise optional).
     * 
     * @return the targetNicResourceId value.
     */
    public String targetNicResourceId() {
        return this.targetNicResourceId;
    }

    /**
     * Set the targetNicResourceId property: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of
     * the nics, then this parameter must be specified. Otherwise optional).
     * 
     * @param targetNicResourceId the targetNicResourceId value to set.
     * @return the NextHopParameters object itself.
     */
    public NextHopParameters withTargetNicResourceId(String targetNicResourceId) {
        this.targetNicResourceId = targetNicResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetResourceId in model NextHopParameters"));
        }
        if (sourceIpAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceIpAddress in model NextHopParameters"));
        }
        if (destinationIpAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationIpAddress in model NextHopParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NextHopParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("sourceIPAddress", this.sourceIpAddress);
        jsonWriter.writeStringField("destinationIPAddress", this.destinationIpAddress);
        jsonWriter.writeStringField("targetNicResourceId", this.targetNicResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NextHopParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NextHopParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NextHopParameters.
     */
    public static NextHopParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NextHopParameters deserializedNextHopParameters = new NextHopParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceId".equals(fieldName)) {
                    deserializedNextHopParameters.targetResourceId = reader.getString();
                } else if ("sourceIPAddress".equals(fieldName)) {
                    deserializedNextHopParameters.sourceIpAddress = reader.getString();
                } else if ("destinationIPAddress".equals(fieldName)) {
                    deserializedNextHopParameters.destinationIpAddress = reader.getString();
                } else if ("targetNicResourceId".equals(fieldName)) {
                    deserializedNextHopParameters.targetNicResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNextHopParameters;
        });
    }
}
