// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines a managed rule group override setting.
 */
@Fluent
public final class ManagedRuleOverride implements JsonSerializable<ManagedRuleOverride> {
    /*
     * Identifier for the managed rule.
     */
    private String ruleId;

    /*
     * The state of the managed rule. Defaults to Disabled if not specified.
     */
    private ManagedRuleEnabledState state;

    /*
     * Describes the override action to be applied when rule matches.
     */
    private ActionType action;

    /**
     * Creates an instance of ManagedRuleOverride class.
     */
    public ManagedRuleOverride() {
    }

    /**
     * Get the ruleId property: Identifier for the managed rule.
     * 
     * @return the ruleId value.
     */
    public String ruleId() {
        return this.ruleId;
    }

    /**
     * Set the ruleId property: Identifier for the managed rule.
     * 
     * @param ruleId the ruleId value to set.
     * @return the ManagedRuleOverride object itself.
     */
    public ManagedRuleOverride withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
     * Get the state property: The state of the managed rule. Defaults to Disabled if not specified.
     * 
     * @return the state value.
     */
    public ManagedRuleEnabledState state() {
        return this.state;
    }

    /**
     * Set the state property: The state of the managed rule. Defaults to Disabled if not specified.
     * 
     * @param state the state value to set.
     * @return the ManagedRuleOverride object itself.
     */
    public ManagedRuleOverride withState(ManagedRuleEnabledState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the action property: Describes the override action to be applied when rule matches.
     * 
     * @return the action value.
     */
    public ActionType action() {
        return this.action;
    }

    /**
     * Set the action property: Describes the override action to be applied when rule matches.
     * 
     * @param action the action value to set.
     * @return the ManagedRuleOverride object itself.
     */
    public ManagedRuleOverride withAction(ActionType action) {
        this.action = action;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property ruleId in model ManagedRuleOverride"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleOverride.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleId", this.ruleId);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleOverride from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleOverride if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedRuleOverride.
     */
    public static ManagedRuleOverride fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleOverride deserializedManagedRuleOverride = new ManagedRuleOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleId".equals(fieldName)) {
                    deserializedManagedRuleOverride.ruleId = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedManagedRuleOverride.state = ManagedRuleEnabledState.fromString(reader.getString());
                } else if ("action".equals(fieldName)) {
                    deserializedManagedRuleOverride.action = ActionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleOverride;
        });
    }
}
