// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.HubVirtualNetworkConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * List of HubVirtualNetworkConnections and a URL nextLink to get the next set of results.
 */
@Fluent
public final class ListHubVirtualNetworkConnectionsResult
    implements JsonSerializable<ListHubVirtualNetworkConnectionsResult> {
    /*
     * List of HubVirtualNetworkConnections.
     */
    private List<HubVirtualNetworkConnectionInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListHubVirtualNetworkConnectionsResult class.
     */
    public ListHubVirtualNetworkConnectionsResult() {
    }

    /**
     * Get the value property: List of HubVirtualNetworkConnections.
     * 
     * @return the value value.
     */
    public List<HubVirtualNetworkConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of HubVirtualNetworkConnections.
     * 
     * @param value the value value to set.
     * @return the ListHubVirtualNetworkConnectionsResult object itself.
     */
    public ListHubVirtualNetworkConnectionsResult withValue(List<HubVirtualNetworkConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListHubVirtualNetworkConnectionsResult object itself.
     */
    public ListHubVirtualNetworkConnectionsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListHubVirtualNetworkConnectionsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListHubVirtualNetworkConnectionsResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListHubVirtualNetworkConnectionsResult.
     */
    public static ListHubVirtualNetworkConnectionsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListHubVirtualNetworkConnectionsResult deserializedListHubVirtualNetworkConnectionsResult
                = new ListHubVirtualNetworkConnectionsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<HubVirtualNetworkConnectionInner> value
                        = reader.readArray(reader1 -> HubVirtualNetworkConnectionInner.fromJson(reader1));
                    deserializedListHubVirtualNetworkConnectionsResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListHubVirtualNetworkConnectionsResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListHubVirtualNetworkConnectionsResult;
        });
    }
}
