// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.HopLinkProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Hop link.
 */
@Immutable
public final class HopLink implements JsonSerializable<HopLink> {
    /*
     * The ID of the next hop.
     */
    private String nextHopId;

    /*
     * Link type.
     */
    private String linkType;

    /*
     * Hop link properties.
     */
    private HopLinkProperties innerProperties;

    /*
     * List of issues.
     */
    private List<ConnectivityIssue> issues;

    /*
     * Provides additional context on links.
     */
    private Map<String, String> context;

    /*
     * Resource ID.
     */
    private String resourceId;

    /**
     * Creates an instance of HopLink class.
     */
    public HopLink() {
    }

    /**
     * Get the nextHopId property: The ID of the next hop.
     * 
     * @return the nextHopId value.
     */
    public String nextHopId() {
        return this.nextHopId;
    }

    /**
     * Get the linkType property: Link type.
     * 
     * @return the linkType value.
     */
    public String linkType() {
        return this.linkType;
    }

    /**
     * Get the innerProperties property: Hop link properties.
     * 
     * @return the innerProperties value.
     */
    private HopLinkProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the issues property: List of issues.
     * 
     * @return the issues value.
     */
    public List<ConnectivityIssue> issues() {
        return this.issues;
    }

    /**
     * Get the context property: Provides additional context on links.
     * 
     * @return the context value.
     */
    public Map<String, String> context() {
        return this.context;
    }

    /**
     * Get the resourceId property: Resource ID.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Get the roundTripTimeMin property: Minimum roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeMin value.
     */
    public Long roundTripTimeMin() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMin();
    }

    /**
     * Get the roundTripTimeAvg property: Average roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeAvg value.
     */
    public Long roundTripTimeAvg() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeAvg();
    }

    /**
     * Get the roundTripTimeMax property: Maximum roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeMax value.
     */
    public Long roundTripTimeMax() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMax();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (issues() != null) {
            issues().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HopLink from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HopLink if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the HopLink.
     */
    public static HopLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HopLink deserializedHopLink = new HopLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextHopId".equals(fieldName)) {
                    deserializedHopLink.nextHopId = reader.getString();
                } else if ("linkType".equals(fieldName)) {
                    deserializedHopLink.linkType = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedHopLink.innerProperties = HopLinkProperties.fromJson(reader);
                } else if ("issues".equals(fieldName)) {
                    List<ConnectivityIssue> issues = reader.readArray(reader1 -> ConnectivityIssue.fromJson(reader1));
                    deserializedHopLink.issues = issues;
                } else if ("context".equals(fieldName)) {
                    Map<String, String> context = reader.readMap(reader1 -> reader1.getString());
                    deserializedHopLink.context = context;
                } else if ("resourceId".equals(fieldName)) {
                    deserializedHopLink.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHopLink;
        });
    }
}
