// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration needed to perform TLS termination &amp; initiation.
 */
@Fluent
public final class FirewallPolicyTransportSecurity implements JsonSerializable<FirewallPolicyTransportSecurity> {
    /*
     * The CA used for intermediate CA generation.
     */
    private FirewallPolicyCertificateAuthority certificateAuthority;

    /**
     * Creates an instance of FirewallPolicyTransportSecurity class.
     */
    public FirewallPolicyTransportSecurity() {
    }

    /**
     * Get the certificateAuthority property: The CA used for intermediate CA generation.
     * 
     * @return the certificateAuthority value.
     */
    public FirewallPolicyCertificateAuthority certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Set the certificateAuthority property: The CA used for intermediate CA generation.
     * 
     * @param certificateAuthority the certificateAuthority value to set.
     * @return the FirewallPolicyTransportSecurity object itself.
     */
    public FirewallPolicyTransportSecurity
        withCertificateAuthority(FirewallPolicyCertificateAuthority certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (certificateAuthority() != null) {
            certificateAuthority().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("certificateAuthority", this.certificateAuthority);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyTransportSecurity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyTransportSecurity if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyTransportSecurity.
     */
    public static FirewallPolicyTransportSecurity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyTransportSecurity deserializedFirewallPolicyTransportSecurity
                = new FirewallPolicyTransportSecurity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificateAuthority".equals(fieldName)) {
                    deserializedFirewallPolicyTransportSecurity.certificateAuthority
                        = FirewallPolicyCertificateAuthority.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyTransportSecurity;
        });
    }
}
