// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains ServiceProviderProperties in an ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitServiceProviderProperties
    implements JsonSerializable<ExpressRouteCircuitServiceProviderProperties> {
    /*
     * The serviceProviderName.
     */
    private String serviceProviderName;

    /*
     * The peering location.
     */
    private String peeringLocation;

    /*
     * The BandwidthInMbps.
     */
    private Integer bandwidthInMbps;

    /**
     * Creates an instance of ExpressRouteCircuitServiceProviderProperties class.
     */
    public ExpressRouteCircuitServiceProviderProperties() {
    }

    /**
     * Get the serviceProviderName property: The serviceProviderName.
     * 
     * @return the serviceProviderName value.
     */
    public String serviceProviderName() {
        return this.serviceProviderName;
    }

    /**
     * Set the serviceProviderName property: The serviceProviderName.
     * 
     * @param serviceProviderName the serviceProviderName value to set.
     * @return the ExpressRouteCircuitServiceProviderProperties object itself.
     */
    public ExpressRouteCircuitServiceProviderProperties withServiceProviderName(String serviceProviderName) {
        this.serviceProviderName = serviceProviderName;
        return this;
    }

    /**
     * Get the peeringLocation property: The peering location.
     * 
     * @return the peeringLocation value.
     */
    public String peeringLocation() {
        return this.peeringLocation;
    }

    /**
     * Set the peeringLocation property: The peering location.
     * 
     * @param peeringLocation the peeringLocation value to set.
     * @return the ExpressRouteCircuitServiceProviderProperties object itself.
     */
    public ExpressRouteCircuitServiceProviderProperties withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    /**
     * Get the bandwidthInMbps property: The BandwidthInMbps.
     * 
     * @return the bandwidthInMbps value.
     */
    public Integer bandwidthInMbps() {
        return this.bandwidthInMbps;
    }

    /**
     * Set the bandwidthInMbps property: The BandwidthInMbps.
     * 
     * @param bandwidthInMbps the bandwidthInMbps value to set.
     * @return the ExpressRouteCircuitServiceProviderProperties object itself.
     */
    public ExpressRouteCircuitServiceProviderProperties withBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceProviderName", this.serviceProviderName);
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeNumberField("bandwidthInMbps", this.bandwidthInMbps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitServiceProviderProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitServiceProviderProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitServiceProviderProperties.
     */
    public static ExpressRouteCircuitServiceProviderProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitServiceProviderProperties deserializedExpressRouteCircuitServiceProviderProperties
                = new ExpressRouteCircuitServiceProviderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceProviderName".equals(fieldName)) {
                    deserializedExpressRouteCircuitServiceProviderProperties.serviceProviderName = reader.getString();
                } else if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteCircuitServiceProviderProperties.peeringLocation = reader.getString();
                } else if ("bandwidthInMbps".equals(fieldName)) {
                    deserializedExpressRouteCircuitServiceProviderProperties.bandwidthInMbps
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitServiceProviderProperties;
        });
    }
}
