// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Reference to container resource in remote resource provider.
 */
@Fluent
public final class Container extends SubResource {
    /**
     * Creates an instance of Container class.
     */
    public Container() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Container withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Container from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Container if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Container.
     */
    public static Container fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Container deserializedContainer = new Container();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedContainer.withId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainer;
        });
    }
}
