// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Virtual Appliance Sku Properties.
 */
@Fluent
public final class BreakOutCategoryPolicies implements JsonSerializable<BreakOutCategoryPolicies> {
    /*
     * Flag to control breakout of o365 allow category.
     */
    private Boolean allow;

    /*
     * Flag to control breakout of o365 optimize category.
     */
    private Boolean optimize;

    /*
     * Flag to control breakout of o365 default category.
     */
    private Boolean defaultProperty;

    /**
     * Creates an instance of BreakOutCategoryPolicies class.
     */
    public BreakOutCategoryPolicies() {
    }

    /**
     * Get the allow property: Flag to control breakout of o365 allow category.
     * 
     * @return the allow value.
     */
    public Boolean allow() {
        return this.allow;
    }

    /**
     * Set the allow property: Flag to control breakout of o365 allow category.
     * 
     * @param allow the allow value to set.
     * @return the BreakOutCategoryPolicies object itself.
     */
    public BreakOutCategoryPolicies withAllow(Boolean allow) {
        this.allow = allow;
        return this;
    }

    /**
     * Get the optimize property: Flag to control breakout of o365 optimize category.
     * 
     * @return the optimize value.
     */
    public Boolean optimize() {
        return this.optimize;
    }

    /**
     * Set the optimize property: Flag to control breakout of o365 optimize category.
     * 
     * @param optimize the optimize value to set.
     * @return the BreakOutCategoryPolicies object itself.
     */
    public BreakOutCategoryPolicies withOptimize(Boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    /**
     * Get the defaultProperty property: Flag to control breakout of o365 default category.
     * 
     * @return the defaultProperty value.
     */
    public Boolean defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: Flag to control breakout of o365 default category.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the BreakOutCategoryPolicies object itself.
     */
    public BreakOutCategoryPolicies withDefaultProperty(Boolean defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allow", this.allow);
        jsonWriter.writeBooleanField("optimize", this.optimize);
        jsonWriter.writeBooleanField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BreakOutCategoryPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BreakOutCategoryPolicies if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BreakOutCategoryPolicies.
     */
    public static BreakOutCategoryPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BreakOutCategoryPolicies deserializedBreakOutCategoryPolicies = new BreakOutCategoryPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allow".equals(fieldName)) {
                    deserializedBreakOutCategoryPolicies.allow = reader.getNullable(JsonReader::getBoolean);
                } else if ("optimize".equals(fieldName)) {
                    deserializedBreakOutCategoryPolicies.optimize = reader.getNullable(JsonReader::getBoolean);
                } else if ("default".equals(fieldName)) {
                    deserializedBreakOutCategoryPolicies.defaultProperty = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBreakOutCategoryPolicies;
        });
    }
}
