// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayLoadDistributionPolicyPropertiesFormat;
import java.io.IOException;
import java.util.List;

/**
 * Load Distribution Policy of an application gateway.
 */
@Fluent
public final class ApplicationGatewayLoadDistributionPolicy extends SubResource {
    /*
     * Properties of the application gateway load distribution policy.
     */
    private ApplicationGatewayLoadDistributionPolicyPropertiesFormat innerProperties;

    /*
     * Name of the load distribution policy that is unique within an Application Gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewayLoadDistributionPolicy class.
     */
    public ApplicationGatewayLoadDistributionPolicy() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway load distribution policy.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayLoadDistributionPolicyPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the load distribution policy that is unique within an Application Gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the load distribution policy that is unique within an Application Gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayLoadDistributionPolicy object itself.
     */
    public ApplicationGatewayLoadDistributionPolicy withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayLoadDistributionPolicy withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the loadDistributionTargets property: Load Distribution Targets resource of an application gateway.
     * 
     * @return the loadDistributionTargets value.
     */
    public List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets() {
        return this.innerProperties() == null ? null : this.innerProperties().loadDistributionTargets();
    }

    /**
     * Set the loadDistributionTargets property: Load Distribution Targets resource of an application gateway.
     * 
     * @param loadDistributionTargets the loadDistributionTargets value to set.
     * @return the ApplicationGatewayLoadDistributionPolicy object itself.
     */
    public ApplicationGatewayLoadDistributionPolicy
        withLoadDistributionTargets(List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayLoadDistributionPolicyPropertiesFormat();
        }
        this.innerProperties().withLoadDistributionTargets(loadDistributionTargets);
        return this;
    }

    /**
     * Get the loadDistributionAlgorithm property: Load Distribution Targets resource of an application gateway.
     * 
     * @return the loadDistributionAlgorithm value.
     */
    public ApplicationGatewayLoadDistributionAlgorithm loadDistributionAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().loadDistributionAlgorithm();
    }

    /**
     * Set the loadDistributionAlgorithm property: Load Distribution Targets resource of an application gateway.
     * 
     * @param loadDistributionAlgorithm the loadDistributionAlgorithm value to set.
     * @return the ApplicationGatewayLoadDistributionPolicy object itself.
     */
    public ApplicationGatewayLoadDistributionPolicy
        withLoadDistributionAlgorithm(ApplicationGatewayLoadDistributionAlgorithm loadDistributionAlgorithm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayLoadDistributionPolicyPropertiesFormat();
        }
        this.innerProperties().withLoadDistributionAlgorithm(loadDistributionAlgorithm);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the Load Distribution Policy resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayLoadDistributionPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayLoadDistributionPolicy if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayLoadDistributionPolicy.
     */
    public static ApplicationGatewayLoadDistributionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayLoadDistributionPolicy deserializedApplicationGatewayLoadDistributionPolicy
                = new ApplicationGatewayLoadDistributionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicy.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicy.innerProperties
                        = ApplicationGatewayLoadDistributionPolicyPropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicy.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicy.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicy.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayLoadDistributionPolicy;
        });
    }
}
