// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayFirewallRuleSetPropertiesFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A web application firewall rule set.
 */
@Fluent
public final class ApplicationGatewayFirewallRuleSet extends Resource {
    /*
     * Properties of the application gateway firewall rule set.
     */
    private ApplicationGatewayFirewallRuleSetPropertiesFormat innerProperties;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewayFirewallRuleSet class.
     */
    public ApplicationGatewayFirewallRuleSet() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway firewall rule set.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayFirewallRuleSetPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the ApplicationGatewayFirewallRuleSet object itself.
     */
    public ApplicationGatewayFirewallRuleSet withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayFirewallRuleSet withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayFirewallRuleSet withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the web application firewall rule set.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the ruleSetType property: The type of the web application firewall rule set.
     * 
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetType();
    }

    /**
     * Set the ruleSetType property: The type of the web application firewall rule set.
     * 
     * @param ruleSetType the ruleSetType value to set.
     * @return the ApplicationGatewayFirewallRuleSet object itself.
     */
    public ApplicationGatewayFirewallRuleSet withRuleSetType(String ruleSetType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleSetType(ruleSetType);
        return this;
    }

    /**
     * Get the ruleSetVersion property: The version of the web application firewall rule set type.
     * 
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetVersion();
    }

    /**
     * Set the ruleSetVersion property: The version of the web application firewall rule set type.
     * 
     * @param ruleSetVersion the ruleSetVersion value to set.
     * @return the ApplicationGatewayFirewallRuleSet object itself.
     */
    public ApplicationGatewayFirewallRuleSet withRuleSetVersion(String ruleSetVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleSetVersion(ruleSetVersion);
        return this;
    }

    /**
     * Get the ruleGroups property: The rule groups of the web application firewall rule set.
     * 
     * @return the ruleGroups value.
     */
    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleGroups();
    }

    /**
     * Set the ruleGroups property: The rule groups of the web application firewall rule set.
     * 
     * @param ruleGroups the ruleGroups value to set.
     * @return the ApplicationGatewayFirewallRuleSet object itself.
     */
    public ApplicationGatewayFirewallRuleSet withRuleGroups(List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleGroups(ruleGroups);
        return this;
    }

    /**
     * Get the tiers property: Tier of an application gateway that support the rule set.
     * 
     * @return the tiers value.
     */
    public List<ApplicationGatewayTierTypes> tiers() {
        return this.innerProperties() == null ? null : this.innerProperties().tiers();
    }

    /**
     * Set the tiers property: Tier of an application gateway that support the rule set.
     * 
     * @param tiers the tiers value to set.
     * @return the ApplicationGatewayFirewallRuleSet object itself.
     */
    public ApplicationGatewayFirewallRuleSet withTiers(List<ApplicationGatewayTierTypes> tiers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withTiers(tiers);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayFirewallRuleSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayFirewallRuleSet if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayFirewallRuleSet.
     */
    public static ApplicationGatewayFirewallRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallRuleSet deserializedApplicationGatewayFirewallRuleSet
                = new ApplicationGatewayFirewallRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationGatewayFirewallRuleSet.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.innerProperties
                        = ApplicationGatewayFirewallRuleSetPropertiesFormat.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayFirewallRuleSet;
        });
    }
}
