// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A web application firewall rule.
 */
@Fluent
public final class ApplicationGatewayFirewallRule implements JsonSerializable<ApplicationGatewayFirewallRule> {
    /*
     * The identifier of the web application firewall rule.
     */
    private int ruleId;

    /*
     * The string representation of the web application firewall rule identifier.
     */
    private String ruleIdString;

    /*
     * The string representation of the web application firewall rule state.
     */
    private ApplicationGatewayWafRuleStateTypes state;

    /*
     * The string representation of the web application firewall rule action.
     */
    private ApplicationGatewayWafRuleActionTypes action;

    /*
     * The description of the web application firewall rule.
     */
    private String description;

    /**
     * Creates an instance of ApplicationGatewayFirewallRule class.
     */
    public ApplicationGatewayFirewallRule() {
    }

    /**
     * Get the ruleId property: The identifier of the web application firewall rule.
     * 
     * @return the ruleId value.
     */
    public int ruleId() {
        return this.ruleId;
    }

    /**
     * Set the ruleId property: The identifier of the web application firewall rule.
     * 
     * @param ruleId the ruleId value to set.
     * @return the ApplicationGatewayFirewallRule object itself.
     */
    public ApplicationGatewayFirewallRule withRuleId(int ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
     * Get the ruleIdString property: The string representation of the web application firewall rule identifier.
     * 
     * @return the ruleIdString value.
     */
    public String ruleIdString() {
        return this.ruleIdString;
    }

    /**
     * Set the ruleIdString property: The string representation of the web application firewall rule identifier.
     * 
     * @param ruleIdString the ruleIdString value to set.
     * @return the ApplicationGatewayFirewallRule object itself.
     */
    public ApplicationGatewayFirewallRule withRuleIdString(String ruleIdString) {
        this.ruleIdString = ruleIdString;
        return this;
    }

    /**
     * Get the state property: The string representation of the web application firewall rule state.
     * 
     * @return the state value.
     */
    public ApplicationGatewayWafRuleStateTypes state() {
        return this.state;
    }

    /**
     * Set the state property: The string representation of the web application firewall rule state.
     * 
     * @param state the state value to set.
     * @return the ApplicationGatewayFirewallRule object itself.
     */
    public ApplicationGatewayFirewallRule withState(ApplicationGatewayWafRuleStateTypes state) {
        this.state = state;
        return this;
    }

    /**
     * Get the action property: The string representation of the web application firewall rule action.
     * 
     * @return the action value.
     */
    public ApplicationGatewayWafRuleActionTypes action() {
        return this.action;
    }

    /**
     * Set the action property: The string representation of the web application firewall rule action.
     * 
     * @param action the action value to set.
     * @return the ApplicationGatewayFirewallRule object itself.
     */
    public ApplicationGatewayFirewallRule withAction(ApplicationGatewayWafRuleActionTypes action) {
        this.action = action;
        return this;
    }

    /**
     * Get the description property: The description of the web application firewall rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the web application firewall rule.
     * 
     * @param description the description value to set.
     * @return the ApplicationGatewayFirewallRule object itself.
     */
    public ApplicationGatewayFirewallRule withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ruleId", this.ruleId);
        jsonWriter.writeStringField("ruleIdString", this.ruleIdString);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayFirewallRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayFirewallRule if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayFirewallRule.
     */
    public static ApplicationGatewayFirewallRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallRule deserializedApplicationGatewayFirewallRule
                = new ApplicationGatewayFirewallRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleId".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.ruleId = reader.getInt();
                } else if ("ruleIdString".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.ruleIdString = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.state
                        = ApplicationGatewayWafRuleStateTypes.fromString(reader.getString());
                } else if ("action".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.action
                        = ApplicationGatewayWafRuleActionTypes.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayFirewallRule;
        });
    }
}
