// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Connection draining allows open connections to a backend server to be active for a specified time after the backend
 * server got removed from the configuration.
 */
@Fluent
public final class ApplicationGatewayConnectionDraining
    implements JsonSerializable<ApplicationGatewayConnectionDraining> {
    /*
     * Whether connection draining is enabled or not.
     */
    private boolean enabled;

    /*
     * The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
     */
    private int drainTimeoutInSec;

    /**
     * Creates an instance of ApplicationGatewayConnectionDraining class.
     */
    public ApplicationGatewayConnectionDraining() {
    }

    /**
     * Get the enabled property: Whether connection draining is enabled or not.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether connection draining is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the ApplicationGatewayConnectionDraining object itself.
     */
    public ApplicationGatewayConnectionDraining withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the drainTimeoutInSec property: The number of seconds connection draining is active. Acceptable values are
     * from 1 second to 3600 seconds.
     * 
     * @return the drainTimeoutInSec value.
     */
    public int drainTimeoutInSec() {
        return this.drainTimeoutInSec;
    }

    /**
     * Set the drainTimeoutInSec property: The number of seconds connection draining is active. Acceptable values are
     * from 1 second to 3600 seconds.
     * 
     * @param drainTimeoutInSec the drainTimeoutInSec value to set.
     * @return the ApplicationGatewayConnectionDraining object itself.
     */
    public ApplicationGatewayConnectionDraining withDrainTimeoutInSec(int drainTimeoutInSec) {
        this.drainTimeoutInSec = drainTimeoutInSec;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeIntField("drainTimeoutInSec", this.drainTimeoutInSec);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayConnectionDraining from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayConnectionDraining if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayConnectionDraining.
     */
    public static ApplicationGatewayConnectionDraining fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayConnectionDraining deserializedApplicationGatewayConnectionDraining
                = new ApplicationGatewayConnectionDraining();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedApplicationGatewayConnectionDraining.enabled = reader.getBoolean();
                } else if ("drainTimeoutInSec".equals(fieldName)) {
                    deserializedApplicationGatewayConnectionDraining.drainTimeoutInSec = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayConnectionDraining;
        });
    }
}
