// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Backend address of an application gateway.
 */
@Fluent
public final class ApplicationGatewayBackendAddress implements JsonSerializable<ApplicationGatewayBackendAddress> {
    /*
     * Fully qualified domain name (FQDN).
     */
    private String fqdn;

    /*
     * IP address.
     */
    private String ipAddress;

    /**
     * Creates an instance of ApplicationGatewayBackendAddress class.
     */
    public ApplicationGatewayBackendAddress() {
    }

    /**
     * Get the fqdn property: Fully qualified domain name (FQDN).
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Set the fqdn property: Fully qualified domain name (FQDN).
     * 
     * @param fqdn the fqdn value to set.
     * @return the ApplicationGatewayBackendAddress object itself.
     */
    public ApplicationGatewayBackendAddress withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    /**
     * Get the ipAddress property: IP address.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: IP address.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the ApplicationGatewayBackendAddress object itself.
     */
    public ApplicationGatewayBackendAddress withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendAddress if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendAddress.
     */
    public static ApplicationGatewayBackendAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendAddress deserializedApplicationGatewayBackendAddress
                = new ApplicationGatewayBackendAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fqdn".equals(fieldName)) {
                    deserializedApplicationGatewayBackendAddress.fqdn = reader.getString();
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedApplicationGatewayBackendAddress.ipAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendAddress;
        });
    }
}
