// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.OfficeTrafficCategory;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * VirtualWAN Resource.
 */
@Fluent
public final class VirtualWanInner extends Resource {
    /*
     * Properties of the virtual WAN.
     */
    private VirtualWanProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of VirtualWanInner class.
     */
    public VirtualWanInner() {
    }

    /**
     * Get the innerProperties property: Properties of the virtual WAN.
     * 
     * @return the innerProperties value.
     */
    private VirtualWanProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualWanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualWanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the disableVpnEncryption property: Vpn encryption to be disabled or not.
     * 
     * @return the disableVpnEncryption value.
     */
    public Boolean disableVpnEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().disableVpnEncryption();
    }

    /**
     * Set the disableVpnEncryption property: Vpn encryption to be disabled or not.
     * 
     * @param disableVpnEncryption the disableVpnEncryption value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withDisableVpnEncryption(disableVpnEncryption);
        return this;
    }

    /**
     * Get the virtualHubs property: List of VirtualHubs in the VirtualWAN.
     * 
     * @return the virtualHubs value.
     */
    public List<SubResource> virtualHubs() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHubs();
    }

    /**
     * Get the vpnSites property: List of VpnSites in the VirtualWAN.
     * 
     * @return the vpnSites value.
     */
    public List<SubResource> vpnSites() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSites();
    }

    /**
     * Get the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     * 
     * @return the allowBranchToBranchTraffic value.
     */
    public Boolean allowBranchToBranchTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBranchToBranchTraffic();
    }

    /**
     * Set the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     * 
     * @param allowBranchToBranchTraffic the allowBranchToBranchTraffic value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowBranchToBranchTraffic(allowBranchToBranchTraffic);
        return this;
    }

    /**
     * Get the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     * 
     * @return the allowVnetToVnetTraffic value.
     */
    public Boolean allowVnetToVnetTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowVnetToVnetTraffic();
    }

    /**
     * Set the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     * 
     * @param allowVnetToVnetTraffic the allowVnetToVnetTraffic value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowVnetToVnetTraffic(allowVnetToVnetTraffic);
        return this;
    }

    /**
     * Get the office365LocalBreakoutCategory property: The office local breakout category.
     * 
     * @return the office365LocalBreakoutCategory value.
     */
    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.innerProperties() == null ? null : this.innerProperties().office365LocalBreakoutCategory();
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual WAN resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the type property: The type of the VirtualWAN.
     * 
     * @return the type value.
     */
    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: The type of the VirtualWAN.
     * 
     * @param type the type value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualWanInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualWanInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualWanInner.
     */
    public static VirtualWanInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualWanInner deserializedVirtualWanInner = new VirtualWanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualWanInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualWanInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedVirtualWanInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualWanInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualWanInner.innerProperties = VirtualWanProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedVirtualWanInner.etag = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedVirtualWanInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualWanInner;
        });
    }
}
