// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GatewayCustomBgpIpAddressIpConfiguration;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A common class for general resource information.
 */
@Fluent
public final class VirtualNetworkGatewayConnectionInner extends Resource {
    /*
     * Properties of the virtual network gateway connection.
     */
    private VirtualNetworkGatewayConnectionPropertiesFormatInner innerProperties
        = new VirtualNetworkGatewayConnectionPropertiesFormatInner();

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of VirtualNetworkGatewayConnectionInner class.
     */
    public VirtualNetworkGatewayConnectionInner() {
    }

    /**
     * Get the innerProperties property: Properties of the virtual network gateway connection.
     * 
     * @return the innerProperties value.
     */
    private VirtualNetworkGatewayConnectionPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualNetworkGatewayConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualNetworkGatewayConnectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the authorizationKey property: The authorizationKey.
     * 
     * @return the authorizationKey value.
     */
    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    /**
     * Set the authorizationKey property: The authorizationKey.
     * 
     * @param authorizationKey the authorizationKey value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    /**
     * Get the virtualNetworkGateway1 property: The reference to virtual network gateway resource.
     * 
     * @return the virtualNetworkGateway1 value.
     */
    public VirtualNetworkGatewayInner virtualNetworkGateway1() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGateway1();
    }

    /**
     * Set the virtualNetworkGateway1 property: The reference to virtual network gateway resource.
     * 
     * @param virtualNetworkGateway1 the virtualNetworkGateway1 value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withVirtualNetworkGateway1(VirtualNetworkGatewayInner virtualNetworkGateway1) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withVirtualNetworkGateway1(virtualNetworkGateway1);
        return this;
    }

    /**
     * Get the virtualNetworkGateway2 property: The reference to virtual network gateway resource.
     * 
     * @return the virtualNetworkGateway2 value.
     */
    public VirtualNetworkGatewayInner virtualNetworkGateway2() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGateway2();
    }

    /**
     * Set the virtualNetworkGateway2 property: The reference to virtual network gateway resource.
     * 
     * @param virtualNetworkGateway2 the virtualNetworkGateway2 value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withVirtualNetworkGateway2(VirtualNetworkGatewayInner virtualNetworkGateway2) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withVirtualNetworkGateway2(virtualNetworkGateway2);
        return this;
    }

    /**
     * Get the localNetworkGateway2 property: The reference to local network gateway resource.
     * 
     * @return the localNetworkGateway2 value.
     */
    public LocalNetworkGatewayInner localNetworkGateway2() {
        return this.innerProperties() == null ? null : this.innerProperties().localNetworkGateway2();
    }

    /**
     * Set the localNetworkGateway2 property: The reference to local network gateway resource.
     * 
     * @param localNetworkGateway2 the localNetworkGateway2 value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withLocalNetworkGateway2(LocalNetworkGatewayInner localNetworkGateway2) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withLocalNetworkGateway2(localNetworkGateway2);
        return this;
    }

    /**
     * Get the ingressNatRules property: List of ingress NatRules.
     * 
     * @return the ingressNatRules value.
     */
    public List<SubResource> ingressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressNatRules();
    }

    /**
     * Set the ingressNatRules property: List of ingress NatRules.
     * 
     * @param ingressNatRules the ingressNatRules value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withIngressNatRules(List<SubResource> ingressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withIngressNatRules(ingressNatRules);
        return this;
    }

    /**
     * Get the egressNatRules property: List of egress NatRules.
     * 
     * @return the egressNatRules value.
     */
    public List<SubResource> egressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().egressNatRules();
    }

    /**
     * Set the egressNatRules property: List of egress NatRules.
     * 
     * @param egressNatRules the egressNatRules value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withEgressNatRules(List<SubResource> egressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEgressNatRules(egressNatRules);
        return this;
    }

    /**
     * Get the connectionType property: Gateway connection type.
     * 
     * @return the connectionType value.
     */
    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    /**
     * Set the connectionType property: Gateway connection type.
     * 
     * @param connectionType the connectionType value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    /**
     * Get the connectionProtocol property: Connection protocol used for this connection.
     * 
     * @return the connectionProtocol value.
     */
    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionProtocol();
    }

    /**
     * Set the connectionProtocol property: Connection protocol used for this connection.
     * 
     * @param connectionProtocol the connectionProtocol value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionProtocol(connectionProtocol);
        return this;
    }

    /**
     * Get the routingWeight property: The routing weight.
     * 
     * @return the routingWeight value.
     */
    public Integer routingWeight() {
        return this.innerProperties() == null ? null : this.innerProperties().routingWeight();
    }

    /**
     * Set the routingWeight property: The routing weight.
     * 
     * @param routingWeight the routingWeight value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withRoutingWeight(Integer routingWeight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withRoutingWeight(routingWeight);
        return this;
    }

    /**
     * Get the dpdTimeoutSeconds property: The dead peer detection timeout of this connection in seconds.
     * 
     * @return the dpdTimeoutSeconds value.
     */
    public Integer dpdTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().dpdTimeoutSeconds();
    }

    /**
     * Set the dpdTimeoutSeconds property: The dead peer detection timeout of this connection in seconds.
     * 
     * @param dpdTimeoutSeconds the dpdTimeoutSeconds value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withDpdTimeoutSeconds(dpdTimeoutSeconds);
        return this;
    }

    /**
     * Get the connectionMode property: The connection mode for this connection.
     * 
     * @return the connectionMode value.
     */
    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionMode();
    }

    /**
     * Set the connectionMode property: The connection mode for this connection.
     * 
     * @param connectionMode the connectionMode value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionMode(connectionMode);
        return this;
    }

    /**
     * Get the sharedKey property: The IPSec shared key.
     * 
     * @return the sharedKey value.
     */
    public String sharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedKey();
    }

    /**
     * Set the sharedKey property: The IPSec shared key.
     * 
     * @param sharedKey the sharedKey value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withSharedKey(String sharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withSharedKey(sharedKey);
        return this;
    }

    /**
     * Get the connectionStatus property: Virtual Network Gateway connection status.
     * 
     * @return the connectionStatus value.
     */
    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionStatus();
    }

    /**
     * Get the tunnelConnectionStatus property: Collection of all tunnels' connection health status.
     * 
     * @return the tunnelConnectionStatus value.
     */
    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().tunnelConnectionStatus();
    }

    /**
     * Get the egressBytesTransferred property: The egress bytes transferred in this connection.
     * 
     * @return the egressBytesTransferred value.
     */
    public Long egressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().egressBytesTransferred();
    }

    /**
     * Get the ingressBytesTransferred property: The ingress bytes transferred in this connection.
     * 
     * @return the ingressBytesTransferred value.
     */
    public Long ingressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressBytesTransferred();
    }

    /**
     * Get the peer property: The reference to peerings resource.
     * 
     * @return the peer value.
     */
    public SubResource peer() {
        return this.innerProperties() == null ? null : this.innerProperties().peer();
    }

    /**
     * Set the peer property: The reference to peerings resource.
     * 
     * @param peer the peer value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withPeer(SubResource peer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withPeer(peer);
        return this;
    }

    /**
     * Get the enableBgp property: EnableBgp flag.
     * 
     * @return the enableBgp value.
     */
    public Boolean enableBgp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgp();
    }

    /**
     * Set the enableBgp property: EnableBgp flag.
     * 
     * @param enableBgp the enableBgp value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withEnableBgp(Boolean enableBgp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEnableBgp(enableBgp);
        return this;
    }

    /**
     * Get the gatewayCustomBgpIpAddresses property: GatewayCustomBgpIpAddresses to be used for virtual network gateway
     * Connection.
     * 
     * @return the gatewayCustomBgpIpAddresses value.
     */
    public List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayCustomBgpIpAddresses();
    }

    /**
     * Set the gatewayCustomBgpIpAddresses property: GatewayCustomBgpIpAddresses to be used for virtual network gateway
     * Connection.
     * 
     * @param gatewayCustomBgpIpAddresses the gatewayCustomBgpIpAddresses value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withGatewayCustomBgpIpAddresses(List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withGatewayCustomBgpIpAddresses(gatewayCustomBgpIpAddresses);
        return this;
    }

    /**
     * Get the useLocalAzureIpAddress property: Use private local Azure IP for the connection.
     * 
     * @return the useLocalAzureIpAddress value.
     */
    public Boolean useLocalAzureIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().useLocalAzureIpAddress();
    }

    /**
     * Set the useLocalAzureIpAddress property: Use private local Azure IP for the connection.
     * 
     * @param useLocalAzureIpAddress the useLocalAzureIpAddress value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withUseLocalAzureIpAddress(useLocalAzureIpAddress);
        return this;
    }

    /**
     * Get the usePolicyBasedTrafficSelectors property: Enable policy-based traffic selectors.
     * 
     * @return the usePolicyBasedTrafficSelectors value.
     */
    public Boolean usePolicyBasedTrafficSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().usePolicyBasedTrafficSelectors();
    }

    /**
     * Set the usePolicyBasedTrafficSelectors property: Enable policy-based traffic selectors.
     * 
     * @param usePolicyBasedTrafficSelectors the usePolicyBasedTrafficSelectors value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withUsePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors);
        return this;
    }

    /**
     * Get the ipsecPolicies property: The IPSec Policies to be considered by this connection.
     * 
     * @return the ipsecPolicies value.
     */
    public List<IpsecPolicy> ipsecPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsecPolicies();
    }

    /**
     * Set the ipsecPolicies property: The IPSec Policies to be considered by this connection.
     * 
     * @param ipsecPolicies the ipsecPolicies value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withIpsecPolicies(ipsecPolicies);
        return this;
    }

    /**
     * Get the trafficSelectorPolicies property: The Traffic Selector Policies to be considered by this connection.
     * 
     * @return the trafficSelectorPolicies value.
     */
    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficSelectorPolicies();
    }

    /**
     * Set the trafficSelectorPolicies property: The Traffic Selector Policies to be considered by this connection.
     * 
     * @param trafficSelectorPolicies the trafficSelectorPolicies value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner
        withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withTrafficSelectorPolicies(trafficSelectorPolicies);
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the virtual network gateway connection resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual network gateway connection resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the expressRouteGatewayBypass property: Bypass ExpressRoute Gateway for data forwarding.
     * 
     * @return the expressRouteGatewayBypass value.
     */
    public Boolean expressRouteGatewayBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteGatewayBypass();
    }

    /**
     * Set the expressRouteGatewayBypass property: Bypass ExpressRoute Gateway for data forwarding.
     * 
     * @param expressRouteGatewayBypass the expressRouteGatewayBypass value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withExpressRouteGatewayBypass(expressRouteGatewayBypass);
        return this;
    }

    /**
     * Get the enablePrivateLinkFastPath property: Bypass the ExpressRoute gateway when accessing private-links.
     * ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     * 
     * @return the enablePrivateLinkFastPath value.
     */
    public Boolean enablePrivateLinkFastPath() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePrivateLinkFastPath();
    }

    /**
     * Set the enablePrivateLinkFastPath property: Bypass the ExpressRoute gateway when accessing private-links.
     * ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     * 
     * @param enablePrivateLinkFastPath the enablePrivateLinkFastPath value to set.
     * @return the VirtualNetworkGatewayConnectionInner object itself.
     */
    public VirtualNetworkGatewayConnectionInner withEnablePrivateLinkFastPath(Boolean enablePrivateLinkFastPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEnablePrivateLinkFastPath(enablePrivateLinkFastPath);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model VirtualNetworkGatewayConnectionInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayConnectionInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayConnectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayConnectionInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayConnectionInner.
     */
    public static VirtualNetworkGatewayConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayConnectionInner deserializedVirtualNetworkGatewayConnectionInner
                = new VirtualNetworkGatewayConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualNetworkGatewayConnectionInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.innerProperties
                        = VirtualNetworkGatewayConnectionPropertiesFormatInner.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.etag = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayConnectionInner;
        });
    }
}
