// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SignaturesOverridesProperties;
import java.io.IOException;

/**
 * Contains all specific policy signatures overrides for the IDPS.
 */
@Fluent
public final class SignaturesOverridesInner extends ProxyResource {
    /*
     * Contains the name of the resource (default)
     */
    private String name;

    /*
     * Will contain the resource id of the signature override resource
     */
    private String id;

    /*
     * Will contain the type of the resource: Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides
     */
    private String type;

    /*
     * Will contain the properties of the resource (the actual signature overrides)
     */
    private SignaturesOverridesProperties properties;

    /**
     * Creates an instance of SignaturesOverridesInner class.
     */
    public SignaturesOverridesInner() {
    }

    /**
     * Get the name property: Contains the name of the resource (default).
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Contains the name of the resource (default).
     * 
     * @param name the name value to set.
     * @return the SignaturesOverridesInner object itself.
     */
    public SignaturesOverridesInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: Will contain the resource id of the signature override resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Will contain the resource id of the signature override resource.
     * 
     * @param id the id value to set.
     * @return the SignaturesOverridesInner object itself.
     */
    public SignaturesOverridesInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: Will contain the type of the resource:
     * Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Will contain the type of the resource:
     * Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides.
     * 
     * @param type the type value to set.
     * @return the SignaturesOverridesInner object itself.
     */
    public SignaturesOverridesInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the properties property: Will contain the properties of the resource (the actual signature overrides).
     * 
     * @return the properties value.
     */
    public SignaturesOverridesProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Will contain the properties of the resource (the actual signature overrides).
     * 
     * @param properties the properties value to set.
     * @return the SignaturesOverridesInner object itself.
     */
    public SignaturesOverridesInner withProperties(SignaturesOverridesProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SignaturesOverridesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SignaturesOverridesInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SignaturesOverridesInner.
     */
    public static SignaturesOverridesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignaturesOverridesInner deserializedSignaturesOverridesInner = new SignaturesOverridesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSignaturesOverridesInner.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedSignaturesOverridesInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSignaturesOverridesInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSignaturesOverridesInner.properties = SignaturesOverridesProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSignaturesOverridesInner;
        });
    }
}
