// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import java.io.IOException;

/**
 * Route resource.
 */
@Fluent
public final class RoutePropertiesFormat implements JsonSerializable<RoutePropertiesFormat> {
    /*
     * The destination CIDR to which the route applies.
     */
    private String addressPrefix;

    /*
     * The type of Azure hop the packet should be sent to.
     */
    private RouteNextHopType nextHopType;

    /*
     * The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type
     * is VirtualAppliance.
     */
    private String nextHopIpAddress;

    /*
     * The provisioning state of the route resource.
     */
    private ProvisioningState provisioningState;

    /*
     * A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    private Boolean hasBgpOverride;

    /**
     * Creates an instance of RoutePropertiesFormat class.
     */
    public RoutePropertiesFormat() {
    }

    /**
     * Get the addressPrefix property: The destination CIDR to which the route applies.
     * 
     * @return the addressPrefix value.
     */
    public String addressPrefix() {
        return this.addressPrefix;
    }

    /**
     * Set the addressPrefix property: The destination CIDR to which the route applies.
     * 
     * @param addressPrefix the addressPrefix value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    /**
     * Get the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @return the nextHopType value.
     */
    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     * 
     * @return the nextHopIpAddress value.
     */
    public String nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    /**
     * Set the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     * 
     * @param nextHopIpAddress the nextHopIpAddress value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withNextHopIpAddress(String nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the route resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     * 
     * @return the hasBgpOverride value.
     */
    public Boolean hasBgpOverride() {
        return this.hasBgpOverride;
    }

    /**
     * Set the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     * 
     * @param hasBgpOverride the hasBgpOverride value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withHasBgpOverride(Boolean hasBgpOverride) {
        this.hasBgpOverride = hasBgpOverride;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nextHopType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property nextHopType in model RoutePropertiesFormat"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutePropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeStringField("nextHopIpAddress", this.nextHopIpAddress);
        jsonWriter.writeBooleanField("hasBgpOverride", this.hasBgpOverride);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutePropertiesFormat if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutePropertiesFormat.
     */
    public static RoutePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutePropertiesFormat deserializedRoutePropertiesFormat = new RoutePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextHopType".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.nextHopType = RouteNextHopType.fromString(reader.getString());
                } else if ("addressPrefix".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.addressPrefix = reader.getString();
                } else if ("nextHopIpAddress".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.nextHopIpAddress = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("hasBgpOverride".equals(fieldName)) {
                    deserializedRoutePropertiesFormat.hasBgpOverride = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutePropertiesFormat;
        });
    }
}
