// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import java.io.IOException;

/**
 * Route resource.
 */
@Fluent
public final class RouteInner extends SubResource {
    /*
     * Properties of the route.
     */
    private RoutePropertiesFormat innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of RouteInner class.
     */
    public RouteInner() {
    }

    /**
     * Get the innerProperties property: Properties of the route.
     * 
     * @return the innerProperties value.
     */
    private RoutePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource.
     * 
     * @param type the type value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the addressPrefix property: The destination CIDR to which the route applies.
     * 
     * @return the addressPrefix value.
     */
    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    /**
     * Set the addressPrefix property: The destination CIDR to which the route applies.
     * 
     * @param addressPrefix the addressPrefix value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    /**
     * Get the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @return the nextHopType value.
     */
    public RouteNextHopType nextHopType() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHopType();
    }

    /**
     * Set the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withNextHopType(RouteNextHopType nextHopType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withNextHopType(nextHopType);
        return this;
    }

    /**
     * Get the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     * 
     * @return the nextHopIpAddress value.
     */
    public String nextHopIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHopIpAddress();
    }

    /**
     * Set the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     * 
     * @param nextHopIpAddress the nextHopIpAddress value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withNextHopIpAddress(String nextHopIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withNextHopIpAddress(nextHopIpAddress);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the route resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     * 
     * @return the hasBgpOverride value.
     */
    public Boolean hasBgpOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().hasBgpOverride();
    }

    /**
     * Set the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     * 
     * @param hasBgpOverride the hasBgpOverride value to set.
     * @return the RouteInner object itself.
     */
    public RouteInner withHasBgpOverride(Boolean hasBgpOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withHasBgpOverride(hasBgpOverride);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the RouteInner.
     */
    public static RouteInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteInner deserializedRouteInner = new RouteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRouteInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedRouteInner.innerProperties = RoutePropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedRouteInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedRouteInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRouteInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteInner;
        });
    }
}
