// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ResourceNavigationLink;
import java.io.IOException;
import java.util.List;

/**
 * Response for ResourceNavigationLinks_List operation.
 */
@Fluent
public final class ResourceNavigationLinksListResultInner
    implements JsonSerializable<ResourceNavigationLinksListResultInner> {
    /*
     * The resource navigation links in a subnet.
     */
    private List<ResourceNavigationLink> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceNavigationLinksListResultInner class.
     */
    public ResourceNavigationLinksListResultInner() {
    }

    /**
     * Get the value property: The resource navigation links in a subnet.
     * 
     * @return the value value.
     */
    public List<ResourceNavigationLink> value() {
        return this.value;
    }

    /**
     * Set the value property: The resource navigation links in a subnet.
     * 
     * @param value the value value to set.
     * @return the ResourceNavigationLinksListResultInner object itself.
     */
    public ResourceNavigationLinksListResultInner withValue(List<ResourceNavigationLink> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNavigationLinksListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNavigationLinksListResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceNavigationLinksListResultInner.
     */
    public static ResourceNavigationLinksListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNavigationLinksListResultInner deserializedResourceNavigationLinksListResultInner
                = new ResourceNavigationLinksListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ResourceNavigationLink> value
                        = reader.readArray(reader1 -> ResourceNavigationLink.fromJson(reader1));
                    deserializedResourceNavigationLinksListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceNavigationLinksListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceNavigationLinksListResultInner;
        });
    }
}
