// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PcError;
import com.azure.resourcemanager.network.models.PcStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Status of packet capture session.
 */
@Fluent
public final class PacketCaptureQueryStatusResultInner
    implements JsonSerializable<PacketCaptureQueryStatusResultInner> {
    /*
     * The name of the packet capture resource.
     */
    private String name;

    /*
     * The ID of the packet capture resource.
     */
    private String id;

    /*
     * The start time of the packet capture session.
     */
    private OffsetDateTime captureStartTime;

    /*
     * The status of the packet capture session.
     */
    private PcStatus packetCaptureStatus;

    /*
     * The reason the current packet capture session was stopped.
     */
    private String stopReason;

    /*
     * List of errors of packet capture session.
     */
    private List<PcError> packetCaptureError;

    /**
     * Creates an instance of PacketCaptureQueryStatusResultInner class.
     */
    public PacketCaptureQueryStatusResultInner() {
    }

    /**
     * Get the name property: The name of the packet capture resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the packet capture resource.
     * 
     * @param name the name value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: The ID of the packet capture resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of the packet capture resource.
     * 
     * @param id the id value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the captureStartTime property: The start time of the packet capture session.
     * 
     * @return the captureStartTime value.
     */
    public OffsetDateTime captureStartTime() {
        return this.captureStartTime;
    }

    /**
     * Set the captureStartTime property: The start time of the packet capture session.
     * 
     * @param captureStartTime the captureStartTime value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withCaptureStartTime(OffsetDateTime captureStartTime) {
        this.captureStartTime = captureStartTime;
        return this;
    }

    /**
     * Get the packetCaptureStatus property: The status of the packet capture session.
     * 
     * @return the packetCaptureStatus value.
     */
    public PcStatus packetCaptureStatus() {
        return this.packetCaptureStatus;
    }

    /**
     * Set the packetCaptureStatus property: The status of the packet capture session.
     * 
     * @param packetCaptureStatus the packetCaptureStatus value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withPacketCaptureStatus(PcStatus packetCaptureStatus) {
        this.packetCaptureStatus = packetCaptureStatus;
        return this;
    }

    /**
     * Get the stopReason property: The reason the current packet capture session was stopped.
     * 
     * @return the stopReason value.
     */
    public String stopReason() {
        return this.stopReason;
    }

    /**
     * Set the stopReason property: The reason the current packet capture session was stopped.
     * 
     * @param stopReason the stopReason value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withStopReason(String stopReason) {
        this.stopReason = stopReason;
        return this;
    }

    /**
     * Get the packetCaptureError property: List of errors of packet capture session.
     * 
     * @return the packetCaptureError value.
     */
    public List<PcError> packetCaptureError() {
        return this.packetCaptureError;
    }

    /**
     * Set the packetCaptureError property: List of errors of packet capture session.
     * 
     * @param packetCaptureError the packetCaptureError value to set.
     * @return the PacketCaptureQueryStatusResultInner object itself.
     */
    public PacketCaptureQueryStatusResultInner withPacketCaptureError(List<PcError> packetCaptureError) {
        this.packetCaptureError = packetCaptureError;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("captureStartTime",
            this.captureStartTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.captureStartTime));
        jsonWriter.writeStringField("packetCaptureStatus",
            this.packetCaptureStatus == null ? null : this.packetCaptureStatus.toString());
        jsonWriter.writeStringField("stopReason", this.stopReason);
        jsonWriter.writeArrayField("packetCaptureError", this.packetCaptureError,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PacketCaptureQueryStatusResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PacketCaptureQueryStatusResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PacketCaptureQueryStatusResultInner.
     */
    public static PacketCaptureQueryStatusResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PacketCaptureQueryStatusResultInner deserializedPacketCaptureQueryStatusResultInner
                = new PacketCaptureQueryStatusResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPacketCaptureQueryStatusResultInner.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedPacketCaptureQueryStatusResultInner.id = reader.getString();
                } else if ("captureStartTime".equals(fieldName)) {
                    deserializedPacketCaptureQueryStatusResultInner.captureStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("packetCaptureStatus".equals(fieldName)) {
                    deserializedPacketCaptureQueryStatusResultInner.packetCaptureStatus
                        = PcStatus.fromString(reader.getString());
                } else if ("stopReason".equals(fieldName)) {
                    deserializedPacketCaptureQueryStatusResultInner.stopReason = reader.getString();
                } else if ("packetCaptureError".equals(fieldName)) {
                    List<PcError> packetCaptureError
                        = reader.readArray(reader1 -> PcError.fromString(reader1.getString()));
                    deserializedPacketCaptureQueryStatusResultInner.packetCaptureError = packetCaptureError;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPacketCaptureQueryStatusResultInner;
        });
    }
}
