// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkVirtualApplianceSkuInstances;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Available NetworkVirtualApplianceSkus
 * 
 * Definition of the NetworkVirtualApplianceSkus resource.
 */
@Fluent
public final class NetworkVirtualApplianceSkuInner extends Resource {
    /*
     * NetworkVirtualApplianceSku properties.
     */
    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of NetworkVirtualApplianceSkuInner class.
     */
    public NetworkVirtualApplianceSkuInner() {
    }

    /**
     * Get the innerProperties property: NetworkVirtualApplianceSku properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the NetworkVirtualApplianceSkuInner object itself.
     */
    public NetworkVirtualApplianceSkuInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkVirtualApplianceSkuInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkVirtualApplianceSkuInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the vendor property: Network Virtual Appliance Sku vendor.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    /**
     * Get the availableVersions property: Available Network Virtual Appliance versions.
     * 
     * @return the availableVersions value.
     */
    public List<String> availableVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().availableVersions();
    }

    /**
     * Get the availableScaleUnits property: The list of scale units available.
     * 
     * @return the availableScaleUnits value.
     */
    public List<NetworkVirtualApplianceSkuInstances> availableScaleUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().availableScaleUnits();
    }

    /**
     * Set the availableScaleUnits property: The list of scale units available.
     * 
     * @param availableScaleUnits the availableScaleUnits value to set.
     * @return the NetworkVirtualApplianceSkuInner object itself.
     */
    public NetworkVirtualApplianceSkuInner
        withAvailableScaleUnits(List<NetworkVirtualApplianceSkuInstances> availableScaleUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualApplianceSkuPropertiesFormat();
        }
        this.innerProperties().withAvailableScaleUnits(availableScaleUnits);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkVirtualApplianceSkuInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkVirtualApplianceSkuInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkVirtualApplianceSkuInner.
     */
    public static NetworkVirtualApplianceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceSkuInner deserializedNetworkVirtualApplianceSkuInner
                = new NetworkVirtualApplianceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkVirtualApplianceSkuInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.innerProperties
                        = NetworkVirtualApplianceSkuPropertiesFormat.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.etag = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkVirtualApplianceSkuInner;
        });
    }
}
