// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.network.models.NetworkInterfaceDnsSettings;
import com.azure.resourcemanager.network.models.NetworkInterfaceMigrationPhase;
import com.azure.resourcemanager.network.models.NetworkInterfaceNicType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * NetworkInterface properties.
 */
@Fluent
public final class NetworkInterfacePropertiesFormatInner
    implements JsonSerializable<NetworkInterfacePropertiesFormatInner> {
    /*
     * The reference to a virtual machine.
     */
    private SubResource virtualMachine;

    /*
     * The reference to the NetworkSecurityGroup resource.
     */
    private NetworkSecurityGroupInner networkSecurityGroup;

    /*
     * A reference to the private endpoint to which the network interface is linked.
     */
    private PrivateEndpointInner privateEndpoint;

    /*
     * A list of IPConfigurations of the network interface.
     */
    private List<NetworkInterfaceIpConfigurationInner> ipConfigurations;

    /*
     * A list of TapConfigurations of the network interface.
     */
    private List<NetworkInterfaceTapConfigurationInner> tapConfigurations;

    /*
     * The DNS settings in network interface.
     */
    private NetworkInterfaceDnsSettings dnsSettings;

    /*
     * The MAC address of the network interface.
     */
    private String macAddress;

    /*
     * Whether this is a primary network interface on a virtual machine.
     */
    private Boolean primary;

    /*
     * Whether the virtual machine this nic is attached to supports encryption.
     */
    private Boolean vnetEncryptionSupported;

    /*
     * If the network interface is configured for accelerated networking. Not applicable to VM sizes which require
     * accelerated networking.
     */
    private Boolean enableAcceleratedNetworking;

    /*
     * Indicates whether to disable tcp state tracking.
     */
    private Boolean disableTcpStateTracking;

    /*
     * Indicates whether IP forwarding is enabled on this network interface.
     */
    private Boolean enableIpForwarding;

    /*
     * A list of references to linked BareMetal resources.
     */
    private List<String> hostedWorkloads;

    /*
     * A reference to the dscp configuration to which the network interface is linked.
     */
    private SubResource dscpConfiguration;

    /*
     * The resource GUID property of the network interface resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the network interface resource.
     */
    private ProvisioningState provisioningState;

    /*
     * WorkloadType of the NetworkInterface for BareMetal resources
     */
    private String workloadType;

    /*
     * Type of Network Interface resource.
     */
    private NetworkInterfaceNicType nicType;

    /*
     * Privatelinkservice of the network interface resource.
     */
    private PrivateLinkServiceInner privateLinkService;

    /*
     * Migration phase of Network Interface resource.
     */
    private NetworkInterfaceMigrationPhase migrationPhase;

    /*
     * Auxiliary mode of Network Interface resource.
     */
    private NetworkInterfaceAuxiliaryMode auxiliaryMode;

    /*
     * Auxiliary sku of Network Interface resource.
     */
    private NetworkInterfaceAuxiliarySku auxiliarySku;

    /**
     * Creates an instance of NetworkInterfacePropertiesFormatInner class.
     */
    public NetworkInterfacePropertiesFormatInner() {
    }

    /**
     * Get the virtualMachine property: The reference to a virtual machine.
     * 
     * @return the virtualMachine value.
     */
    public SubResource virtualMachine() {
        return this.virtualMachine;
    }

    /**
     * Get the networkSecurityGroup property: The reference to the NetworkSecurityGroup resource.
     * 
     * @return the networkSecurityGroup value.
     */
    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    /**
     * Set the networkSecurityGroup property: The reference to the NetworkSecurityGroup resource.
     * 
     * @param networkSecurityGroup the networkSecurityGroup value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner
        withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    /**
     * Get the privateEndpoint property: A reference to the private endpoint to which the network interface is linked.
     * 
     * @return the privateEndpoint value.
     */
    public PrivateEndpointInner privateEndpoint() {
        return this.privateEndpoint;
    }

    /**
     * Get the ipConfigurations property: A list of IPConfigurations of the network interface.
     * 
     * @return the ipConfigurations value.
     */
    public List<NetworkInterfaceIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: A list of IPConfigurations of the network interface.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner
        withIpConfigurations(List<NetworkInterfaceIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Get the tapConfigurations property: A list of TapConfigurations of the network interface.
     * 
     * @return the tapConfigurations value.
     */
    public List<NetworkInterfaceTapConfigurationInner> tapConfigurations() {
        return this.tapConfigurations;
    }

    /**
     * Get the dnsSettings property: The DNS settings in network interface.
     * 
     * @return the dnsSettings value.
     */
    public NetworkInterfaceDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    /**
     * Set the dnsSettings property: The DNS settings in network interface.
     * 
     * @param dnsSettings the dnsSettings value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withDnsSettings(NetworkInterfaceDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    /**
     * Get the macAddress property: The MAC address of the network interface.
     * 
     * @return the macAddress value.
     */
    public String macAddress() {
        return this.macAddress;
    }

    /**
     * Get the primary property: Whether this is a primary network interface on a virtual machine.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Get the vnetEncryptionSupported property: Whether the virtual machine this nic is attached to supports
     * encryption.
     * 
     * @return the vnetEncryptionSupported value.
     */
    public Boolean vnetEncryptionSupported() {
        return this.vnetEncryptionSupported;
    }

    /**
     * Get the enableAcceleratedNetworking property: If the network interface is configured for accelerated networking.
     * Not applicable to VM sizes which require accelerated networking.
     * 
     * @return the enableAcceleratedNetworking value.
     */
    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    /**
     * Set the enableAcceleratedNetworking property: If the network interface is configured for accelerated networking.
     * Not applicable to VM sizes which require accelerated networking.
     * 
     * @param enableAcceleratedNetworking the enableAcceleratedNetworking value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    /**
     * Get the disableTcpStateTracking property: Indicates whether to disable tcp state tracking.
     * 
     * @return the disableTcpStateTracking value.
     */
    public Boolean disableTcpStateTracking() {
        return this.disableTcpStateTracking;
    }

    /**
     * Set the disableTcpStateTracking property: Indicates whether to disable tcp state tracking.
     * 
     * @param disableTcpStateTracking the disableTcpStateTracking value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        this.disableTcpStateTracking = disableTcpStateTracking;
        return this;
    }

    /**
     * Get the enableIpForwarding property: Indicates whether IP forwarding is enabled on this network interface.
     * 
     * @return the enableIpForwarding value.
     */
    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    /**
     * Set the enableIpForwarding property: Indicates whether IP forwarding is enabled on this network interface.
     * 
     * @param enableIpForwarding the enableIpForwarding value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    /**
     * Get the hostedWorkloads property: A list of references to linked BareMetal resources.
     * 
     * @return the hostedWorkloads value.
     */
    public List<String> hostedWorkloads() {
        return this.hostedWorkloads;
    }

    /**
     * Get the dscpConfiguration property: A reference to the dscp configuration to which the network interface is
     * linked.
     * 
     * @return the dscpConfiguration value.
     */
    public SubResource dscpConfiguration() {
        return this.dscpConfiguration;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the network interface resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network interface resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the workloadType property: WorkloadType of the NetworkInterface for BareMetal resources.
     * 
     * @return the workloadType value.
     */
    public String workloadType() {
        return this.workloadType;
    }

    /**
     * Set the workloadType property: WorkloadType of the NetworkInterface for BareMetal resources.
     * 
     * @param workloadType the workloadType value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withWorkloadType(String workloadType) {
        this.workloadType = workloadType;
        return this;
    }

    /**
     * Get the nicType property: Type of Network Interface resource.
     * 
     * @return the nicType value.
     */
    public NetworkInterfaceNicType nicType() {
        return this.nicType;
    }

    /**
     * Set the nicType property: Type of Network Interface resource.
     * 
     * @param nicType the nicType value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withNicType(NetworkInterfaceNicType nicType) {
        this.nicType = nicType;
        return this;
    }

    /**
     * Get the privateLinkService property: Privatelinkservice of the network interface resource.
     * 
     * @return the privateLinkService value.
     */
    public PrivateLinkServiceInner privateLinkService() {
        return this.privateLinkService;
    }

    /**
     * Set the privateLinkService property: Privatelinkservice of the network interface resource.
     * 
     * @param privateLinkService the privateLinkService value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withPrivateLinkService(PrivateLinkServiceInner privateLinkService) {
        this.privateLinkService = privateLinkService;
        return this;
    }

    /**
     * Get the migrationPhase property: Migration phase of Network Interface resource.
     * 
     * @return the migrationPhase value.
     */
    public NetworkInterfaceMigrationPhase migrationPhase() {
        return this.migrationPhase;
    }

    /**
     * Set the migrationPhase property: Migration phase of Network Interface resource.
     * 
     * @param migrationPhase the migrationPhase value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withMigrationPhase(NetworkInterfaceMigrationPhase migrationPhase) {
        this.migrationPhase = migrationPhase;
        return this;
    }

    /**
     * Get the auxiliaryMode property: Auxiliary mode of Network Interface resource.
     * 
     * @return the auxiliaryMode value.
     */
    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.auxiliaryMode;
    }

    /**
     * Set the auxiliaryMode property: Auxiliary mode of Network Interface resource.
     * 
     * @param auxiliaryMode the auxiliaryMode value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        this.auxiliaryMode = auxiliaryMode;
        return this;
    }

    /**
     * Get the auxiliarySku property: Auxiliary sku of Network Interface resource.
     * 
     * @return the auxiliarySku value.
     */
    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.auxiliarySku;
    }

    /**
     * Set the auxiliarySku property: Auxiliary sku of Network Interface resource.
     * 
     * @param auxiliarySku the auxiliarySku value to set.
     * @return the NetworkInterfacePropertiesFormatInner object itself.
     */
    public NetworkInterfacePropertiesFormatInner withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        this.auxiliarySku = auxiliarySku;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkSecurityGroup() != null) {
            networkSecurityGroup().validate();
        }
        if (privateEndpoint() != null) {
            privateEndpoint().validate();
        }
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
        if (tapConfigurations() != null) {
            tapConfigurations().forEach(e -> e.validate());
        }
        if (dnsSettings() != null) {
            dnsSettings().validate();
        }
        if (privateLinkService() != null) {
            privateLinkService().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkSecurityGroup", this.networkSecurityGroup);
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("dnsSettings", this.dnsSettings);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        jsonWriter.writeBooleanField("disableTcpStateTracking", this.disableTcpStateTracking);
        jsonWriter.writeBooleanField("enableIPForwarding", this.enableIpForwarding);
        jsonWriter.writeStringField("workloadType", this.workloadType);
        jsonWriter.writeStringField("nicType", this.nicType == null ? null : this.nicType.toString());
        jsonWriter.writeJsonField("privateLinkService", this.privateLinkService);
        jsonWriter.writeStringField("migrationPhase",
            this.migrationPhase == null ? null : this.migrationPhase.toString());
        jsonWriter.writeStringField("auxiliaryMode", this.auxiliaryMode == null ? null : this.auxiliaryMode.toString());
        jsonWriter.writeStringField("auxiliarySku", this.auxiliarySku == null ? null : this.auxiliarySku.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkInterfacePropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkInterfacePropertiesFormatInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkInterfacePropertiesFormatInner.
     */
    public static NetworkInterfacePropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkInterfacePropertiesFormatInner deserializedNetworkInterfacePropertiesFormatInner
                = new NetworkInterfacePropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualMachine".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.virtualMachine = SubResource.fromJson(reader);
                } else if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.networkSecurityGroup
                        = NetworkSecurityGroupInner.fromJson(reader);
                } else if ("privateEndpoint".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.privateEndpoint
                        = PrivateEndpointInner.fromJson(reader);
                } else if ("ipConfigurations".equals(fieldName)) {
                    List<NetworkInterfaceIpConfigurationInner> ipConfigurations
                        = reader.readArray(reader1 -> NetworkInterfaceIpConfigurationInner.fromJson(reader1));
                    deserializedNetworkInterfacePropertiesFormatInner.ipConfigurations = ipConfigurations;
                } else if ("tapConfigurations".equals(fieldName)) {
                    List<NetworkInterfaceTapConfigurationInner> tapConfigurations
                        = reader.readArray(reader1 -> NetworkInterfaceTapConfigurationInner.fromJson(reader1));
                    deserializedNetworkInterfacePropertiesFormatInner.tapConfigurations = tapConfigurations;
                } else if ("dnsSettings".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.dnsSettings
                        = NetworkInterfaceDnsSettings.fromJson(reader);
                } else if ("macAddress".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.macAddress = reader.getString();
                } else if ("primary".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("vnetEncryptionSupported".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.vnetEncryptionSupported
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.enableAcceleratedNetworking
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("disableTcpStateTracking".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.disableTcpStateTracking
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableIPForwarding".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.enableIpForwarding
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("hostedWorkloads".equals(fieldName)) {
                    List<String> hostedWorkloads = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkInterfacePropertiesFormatInner.hostedWorkloads = hostedWorkloads;
                } else if ("dscpConfiguration".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.dscpConfiguration = SubResource.fromJson(reader);
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("workloadType".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.workloadType = reader.getString();
                } else if ("nicType".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.nicType
                        = NetworkInterfaceNicType.fromString(reader.getString());
                } else if ("privateLinkService".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.privateLinkService
                        = PrivateLinkServiceInner.fromJson(reader);
                } else if ("migrationPhase".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.migrationPhase
                        = NetworkInterfaceMigrationPhase.fromString(reader.getString());
                } else if ("auxiliaryMode".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.auxiliaryMode
                        = NetworkInterfaceAuxiliaryMode.fromString(reader.getString());
                } else if ("auxiliarySku".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.auxiliarySku
                        = NetworkInterfaceAuxiliarySku.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkInterfacePropertiesFormatInner;
        });
    }
}
