// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddressAdminState;
import com.azure.resourcemanager.network.models.NatRulePortMapping;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the load balancer backend addresses.
 */
@Fluent
public final class LoadBalancerBackendAddressPropertiesFormat
    implements JsonSerializable<LoadBalancerBackendAddressPropertiesFormat> {
    /*
     * Reference to an existing virtual network.
     */
    private SubResource virtualNetwork;

    /*
     * Reference to an existing subnet.
     */
    private SubResource subnet;

    /*
     * IP Address belonging to the referenced virtual network.
     */
    private String ipAddress;

    /*
     * Reference to IP address defined in network interfaces.
     */
    private SubResource networkInterfaceIpConfiguration;

    /*
     * Reference to the frontend ip address configuration defined in regional loadbalancer.
     */
    private SubResource loadBalancerFrontendIpConfiguration;

    /*
     * Collection of inbound NAT rule port mappings.
     */
    private List<NatRulePortMapping> inboundNatRulesPortMapping;

    /*
     * A list of administrative states which once set can override health probe so that Load Balancer will always
     * forward new connections to backend, or deny new connections and reset existing connections.
     */
    private LoadBalancerBackendAddressAdminState adminState;

    /**
     * Creates an instance of LoadBalancerBackendAddressPropertiesFormat class.
     */
    public LoadBalancerBackendAddressPropertiesFormat() {
    }

    /**
     * Get the virtualNetwork property: Reference to an existing virtual network.
     * 
     * @return the virtualNetwork value.
     */
    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    /**
     * Set the virtualNetwork property: Reference to an existing virtual network.
     * 
     * @param virtualNetwork the virtualNetwork value to set.
     * @return the LoadBalancerBackendAddressPropertiesFormat object itself.
     */
    public LoadBalancerBackendAddressPropertiesFormat withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    /**
     * Get the subnet property: Reference to an existing subnet.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Reference to an existing subnet.
     * 
     * @param subnet the subnet value to set.
     * @return the LoadBalancerBackendAddressPropertiesFormat object itself.
     */
    public LoadBalancerBackendAddressPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the ipAddress property: IP Address belonging to the referenced virtual network.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: IP Address belonging to the referenced virtual network.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the LoadBalancerBackendAddressPropertiesFormat object itself.
     */
    public LoadBalancerBackendAddressPropertiesFormat withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the networkInterfaceIpConfiguration property: Reference to IP address defined in network interfaces.
     * 
     * @return the networkInterfaceIpConfiguration value.
     */
    public SubResource networkInterfaceIpConfiguration() {
        return this.networkInterfaceIpConfiguration;
    }

    /**
     * Get the loadBalancerFrontendIpConfiguration property: Reference to the frontend ip address configuration defined
     * in regional loadbalancer.
     * 
     * @return the loadBalancerFrontendIpConfiguration value.
     */
    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.loadBalancerFrontendIpConfiguration;
    }

    /**
     * Set the loadBalancerFrontendIpConfiguration property: Reference to the frontend ip address configuration defined
     * in regional loadbalancer.
     * 
     * @param loadBalancerFrontendIpConfiguration the loadBalancerFrontendIpConfiguration value to set.
     * @return the LoadBalancerBackendAddressPropertiesFormat object itself.
     */
    public LoadBalancerBackendAddressPropertiesFormat
        withLoadBalancerFrontendIpConfiguration(SubResource loadBalancerFrontendIpConfiguration) {
        this.loadBalancerFrontendIpConfiguration = loadBalancerFrontendIpConfiguration;
        return this;
    }

    /**
     * Get the inboundNatRulesPortMapping property: Collection of inbound NAT rule port mappings.
     * 
     * @return the inboundNatRulesPortMapping value.
     */
    public List<NatRulePortMapping> inboundNatRulesPortMapping() {
        return this.inboundNatRulesPortMapping;
    }

    /**
     * Get the adminState property: A list of administrative states which once set can override health probe so that
     * Load Balancer will always forward new connections to backend, or deny new connections and reset existing
     * connections.
     * 
     * @return the adminState value.
     */
    public LoadBalancerBackendAddressAdminState adminState() {
        return this.adminState;
    }

    /**
     * Set the adminState property: A list of administrative states which once set can override health probe so that
     * Load Balancer will always forward new connections to backend, or deny new connections and reset existing
     * connections.
     * 
     * @param adminState the adminState value to set.
     * @return the LoadBalancerBackendAddressPropertiesFormat object itself.
     */
    public LoadBalancerBackendAddressPropertiesFormat withAdminState(LoadBalancerBackendAddressAdminState adminState) {
        this.adminState = adminState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inboundNatRulesPortMapping() != null) {
            inboundNatRulesPortMapping().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", this.virtualNetwork);
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeJsonField("loadBalancerFrontendIPConfiguration", this.loadBalancerFrontendIpConfiguration);
        jsonWriter.writeStringField("adminState", this.adminState == null ? null : this.adminState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerBackendAddressPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerBackendAddressPropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerBackendAddressPropertiesFormat.
     */
    public static LoadBalancerBackendAddressPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerBackendAddressPropertiesFormat deserializedLoadBalancerBackendAddressPropertiesFormat
                = new LoadBalancerBackendAddressPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetwork".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.virtualNetwork
                        = SubResource.fromJson(reader);
                } else if ("subnet".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.subnet = SubResource.fromJson(reader);
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.ipAddress = reader.getString();
                } else if ("networkInterfaceIPConfiguration".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.networkInterfaceIpConfiguration
                        = SubResource.fromJson(reader);
                } else if ("loadBalancerFrontendIPConfiguration".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.loadBalancerFrontendIpConfiguration
                        = SubResource.fromJson(reader);
                } else if ("inboundNatRulesPortMapping".equals(fieldName)) {
                    List<NatRulePortMapping> inboundNatRulesPortMapping
                        = reader.readArray(reader1 -> NatRulePortMapping.fromJson(reader1));
                    deserializedLoadBalancerBackendAddressPropertiesFormat.inboundNatRulesPortMapping
                        = inboundNatRulesPortMapping;
                } else if ("adminState".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.adminState
                        = LoadBalancerBackendAddressAdminState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerBackendAddressPropertiesFormat;
        });
    }
}
