// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * List of SNAT IP Prefixes learnt by firewall to not SNAT.
 */
@Fluent
public final class IpPrefixesListInner implements JsonSerializable<IpPrefixesListInner> {
    /*
     * IP Prefix value.
     */
    private List<String> ipPrefixes;

    /**
     * Creates an instance of IpPrefixesListInner class.
     */
    public IpPrefixesListInner() {
    }

    /**
     * Get the ipPrefixes property: IP Prefix value.
     * 
     * @return the ipPrefixes value.
     */
    public List<String> ipPrefixes() {
        return this.ipPrefixes;
    }

    /**
     * Set the ipPrefixes property: IP Prefix value.
     * 
     * @param ipPrefixes the ipPrefixes value to set.
     * @return the IpPrefixesListInner object itself.
     */
    public IpPrefixesListInner withIpPrefixes(List<String> ipPrefixes) {
        this.ipPrefixes = ipPrefixes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipPrefixes", this.ipPrefixes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpPrefixesListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpPrefixesListInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpPrefixesListInner.
     */
    public static IpPrefixesListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpPrefixesListInner deserializedIpPrefixesListInner = new IpPrefixesListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipPrefixes".equals(fieldName)) {
                    List<String> ipPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpPrefixesListInner.ipPrefixes = ipPrefixes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpPrefixesListInner;
        });
    }
}
