// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Frontend IP Configuration of the load balancer.
 */
@Fluent
public final class FrontendIpConfigurationPropertiesFormatInner
    implements JsonSerializable<FrontendIpConfigurationPropertiesFormatInner> {
    /*
     * An array of references to inbound rules that use this frontend IP.
     */
    private List<SubResource> inboundNatRules;

    /*
     * An array of references to inbound pools that use this frontend IP.
     */
    private List<SubResource> inboundNatPools;

    /*
     * An array of references to outbound rules that use this frontend IP.
     */
    private List<SubResource> outboundRules;

    /*
     * An array of references to load balancing rules that use this frontend IP.
     */
    private List<SubResource> loadBalancingRules;

    /*
     * The private IP address of the IP configuration.
     */
    private String privateIpAddress;

    /*
     * The Private IP allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
     */
    private IpVersion privateIpAddressVersion;

    /*
     * The reference to the subnet resource.
     */
    private SubnetInner subnet;

    /*
     * The reference to the Public IP resource.
     */
    private PublicIpAddressInner publicIpAddress;

    /*
     * The reference to the Public IP Prefix resource.
     */
    private SubResource publicIpPrefix;

    /*
     * The reference to gateway load balancer frontend IP.
     */
    private SubResource gatewayLoadBalancer;

    /*
     * The provisioning state of the frontend IP configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of FrontendIpConfigurationPropertiesFormatInner class.
     */
    public FrontendIpConfigurationPropertiesFormatInner() {
    }

    /**
     * Get the inboundNatRules property: An array of references to inbound rules that use this frontend IP.
     * 
     * @return the inboundNatRules value.
     */
    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    /**
     * Get the inboundNatPools property: An array of references to inbound pools that use this frontend IP.
     * 
     * @return the inboundNatPools value.
     */
    public List<SubResource> inboundNatPools() {
        return this.inboundNatPools;
    }

    /**
     * Get the outboundRules property: An array of references to outbound rules that use this frontend IP.
     * 
     * @return the outboundRules value.
     */
    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    /**
     * Get the loadBalancingRules property: An array of references to load balancing rules that use this frontend IP.
     * 
     * @return the loadBalancingRules value.
     */
    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    /**
     * Get the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The Private IP allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The Private IP allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the privateIpAddressVersion property: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken
     * as IPv4.
     * 
     * @return the privateIpAddressVersion value.
     */
    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    /**
     * Set the privateIpAddressVersion property: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken
     * as IPv4.
     * 
     * @param privateIpAddressVersion the privateIpAddressVersion value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    /**
     * Get the subnet property: The reference to the subnet resource.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: The reference to the Public IP resource.
     * 
     * @return the publicIpAddress value.
     */
    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: The reference to the Public IP resource.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the publicIpPrefix property: The reference to the Public IP Prefix resource.
     * 
     * @return the publicIpPrefix value.
     */
    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    /**
     * Set the publicIpPrefix property: The reference to the Public IP Prefix resource.
     * 
     * @param publicIpPrefix the publicIpPrefix value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    /**
     * Get the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     * 
     * @return the gatewayLoadBalancer value.
     */
    public SubResource gatewayLoadBalancer() {
        return this.gatewayLoadBalancer;
    }

    /**
     * Set the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     * 
     * @param gatewayLoadBalancer the gatewayLoadBalancer value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withGatewayLoadBalancer(SubResource gatewayLoadBalancer) {
        this.gatewayLoadBalancer = gatewayLoadBalancer;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend IP configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
        if (publicIpAddress() != null) {
            publicIpAddress().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeStringField("privateIPAddressVersion",
            this.privateIpAddressVersion == null ? null : this.privateIpAddressVersion.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        jsonWriter.writeJsonField("publicIPPrefix", this.publicIpPrefix);
        jsonWriter.writeJsonField("gatewayLoadBalancer", this.gatewayLoadBalancer);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FrontendIpConfigurationPropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FrontendIpConfigurationPropertiesFormatInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FrontendIpConfigurationPropertiesFormatInner.
     */
    public static FrontendIpConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FrontendIpConfigurationPropertiesFormatInner deserializedFrontendIpConfigurationPropertiesFormatInner
                = new FrontendIpConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inboundNatRules".equals(fieldName)) {
                    List<SubResource> inboundNatRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedFrontendIpConfigurationPropertiesFormatInner.inboundNatRules = inboundNatRules;
                } else if ("inboundNatPools".equals(fieldName)) {
                    List<SubResource> inboundNatPools = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedFrontendIpConfigurationPropertiesFormatInner.inboundNatPools = inboundNatPools;
                } else if ("outboundRules".equals(fieldName)) {
                    List<SubResource> outboundRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedFrontendIpConfigurationPropertiesFormatInner.outboundRules = outboundRules;
                } else if ("loadBalancingRules".equals(fieldName)) {
                    List<SubResource> loadBalancingRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedFrontendIpConfigurationPropertiesFormatInner.loadBalancingRules = loadBalancingRules;
                } else if ("privateIPAddress".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAddress = reader.getString();
                } else if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAddressVersion
                        = IpVersion.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.subnet = SubnetInner.fromJson(reader);
                } else if ("publicIPAddress".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.publicIpAddress
                        = PublicIpAddressInner.fromJson(reader);
                } else if ("publicIPPrefix".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.publicIpPrefix
                        = SubResource.fromJson(reader);
                } else if ("gatewayLoadBalancer".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.gatewayLoadBalancer
                        = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFrontendIpConfigurationPropertiesFormatInner;
        });
    }
}
