// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRoutePortsLocationBandwidths;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRoutePorts Location Properties
 * 
 * Properties specific to ExpressRoutePorts peering location resources.
 */
@Fluent
public final class ExpressRoutePortsLocationPropertiesFormat
    implements JsonSerializable<ExpressRoutePortsLocationPropertiesFormat> {
    /*
     * Address of peering location.
     */
    private String address;

    /*
     * Contact details of peering locations.
     */
    private String contact;

    /*
     * The inventory of available ExpressRoutePort bandwidths.
     */
    private List<ExpressRoutePortsLocationBandwidths> availableBandwidths;

    /*
     * The provisioning state of the express route port location resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ExpressRoutePortsLocationPropertiesFormat class.
     */
    public ExpressRoutePortsLocationPropertiesFormat() {
    }

    /**
     * Get the address property: Address of peering location.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Get the contact property: Contact details of peering locations.
     * 
     * @return the contact value.
     */
    public String contact() {
        return this.contact;
    }

    /**
     * Get the availableBandwidths property: The inventory of available ExpressRoutePort bandwidths.
     * 
     * @return the availableBandwidths value.
     */
    public List<ExpressRoutePortsLocationBandwidths> availableBandwidths() {
        return this.availableBandwidths;
    }

    /**
     * Set the availableBandwidths property: The inventory of available ExpressRoutePort bandwidths.
     * 
     * @param availableBandwidths the availableBandwidths value to set.
     * @return the ExpressRoutePortsLocationPropertiesFormat object itself.
     */
    public ExpressRoutePortsLocationPropertiesFormat
        withAvailableBandwidths(List<ExpressRoutePortsLocationBandwidths> availableBandwidths) {
        this.availableBandwidths = availableBandwidths;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route port location resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (availableBandwidths() != null) {
            availableBandwidths().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("availableBandwidths", this.availableBandwidths,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRoutePortsLocationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRoutePortsLocationPropertiesFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRoutePortsLocationPropertiesFormat.
     */
    public static ExpressRoutePortsLocationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortsLocationPropertiesFormat deserializedExpressRoutePortsLocationPropertiesFormat
                = new ExpressRoutePortsLocationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationPropertiesFormat.address = reader.getString();
                } else if ("contact".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationPropertiesFormat.contact = reader.getString();
                } else if ("availableBandwidths".equals(fieldName)) {
                    List<ExpressRoutePortsLocationBandwidths> availableBandwidths
                        = reader.readArray(reader1 -> ExpressRoutePortsLocationBandwidths.fromJson(reader1));
                    deserializedExpressRoutePortsLocationPropertiesFormat.availableBandwidths = availableBandwidths;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRoutePortsLocationPropertiesFormat;
        });
    }
}
