// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response for the CheckDnsNameAvailability API service call.
 */
@Fluent
public final class DnsNameAvailabilityResultInner implements JsonSerializable<DnsNameAvailabilityResultInner> {
    /*
     * Domain availability (True/False).
     */
    private Boolean available;

    /**
     * Creates an instance of DnsNameAvailabilityResultInner class.
     */
    public DnsNameAvailabilityResultInner() {
    }

    /**
     * Get the available property: Domain availability (True/False).
     * 
     * @return the available value.
     */
    public Boolean available() {
        return this.available;
    }

    /**
     * Set the available property: Domain availability (True/False).
     * 
     * @param available the available value to set.
     * @return the DnsNameAvailabilityResultInner object itself.
     */
    public DnsNameAvailabilityResultInner withAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("available", this.available);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnsNameAvailabilityResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnsNameAvailabilityResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DnsNameAvailabilityResultInner.
     */
    public static DnsNameAvailabilityResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnsNameAvailabilityResultInner deserializedDnsNameAvailabilityResultInner
                = new DnsNameAvailabilityResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("available".equals(fieldName)) {
                    deserializedDnsNameAvailabilityResultInner.available = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnsNameAvailabilityResultInner;
        });
    }
}
