// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.azure.resourcemanager.network.models.ConnectionMonitorType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Describes the properties of a connection monitor.
 */
@Fluent
public final class ConnectionMonitorResultProperties extends ConnectionMonitorParameters {
    /*
     * The provisioning state of the connection monitor.
     */
    private ProvisioningState provisioningState;

    /*
     * The date and time when the connection monitor was started.
     */
    private OffsetDateTime startTime;

    /*
     * The monitoring status of the connection monitor.
     */
    private String monitoringStatus;

    /*
     * Type of connection monitor.
     */
    private ConnectionMonitorType connectionMonitorType;

    /**
     * Creates an instance of ConnectionMonitorResultProperties class.
     */
    public ConnectionMonitorResultProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the connection monitor.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the startTime property: The date and time when the connection monitor was started.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the monitoringStatus property: The monitoring status of the connection monitor.
     * 
     * @return the monitoringStatus value.
     */
    public String monitoringStatus() {
        return this.monitoringStatus;
    }

    /**
     * Get the connectionMonitorType property: Type of connection monitor.
     * 
     * @return the connectionMonitorType value.
     */
    public ConnectionMonitorType connectionMonitorType() {
        return this.connectionMonitorType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withSource(ConnectionMonitorSource source) {
        super.withSource(source);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withDestination(ConnectionMonitorDestination destination) {
        super.withDestination(destination);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withAutoStart(Boolean autoStart) {
        super.withAutoStart(autoStart);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        super.withMonitoringIntervalInSeconds(monitoringIntervalInSeconds);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        super.withEndpoints(endpoints);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties
        withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        super.withTestConfigurations(testConfigurations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        super.withTestGroups(testGroups);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withOutputs(List<ConnectionMonitorOutput> outputs) {
        super.withOutputs(outputs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConnectionMonitorResultProperties withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", source());
        jsonWriter.writeJsonField("destination", destination());
        jsonWriter.writeBooleanField("autoStart", autoStart());
        jsonWriter.writeNumberField("monitoringIntervalInSeconds", monitoringIntervalInSeconds());
        jsonWriter.writeArrayField("endpoints", endpoints(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("testConfigurations", testConfigurations(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("testGroups", testGroups(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", outputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("notes", notes());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorResultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorResultProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorResultProperties.
     */
    public static ConnectionMonitorResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorResultProperties deserializedConnectionMonitorResultProperties
                = new ConnectionMonitorResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withSource(ConnectionMonitorSource.fromJson(reader));
                } else if ("destination".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties
                        .withDestination(ConnectionMonitorDestination.fromJson(reader));
                } else if ("autoStart".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties
                        .withAutoStart(reader.getNullable(JsonReader::getBoolean));
                } else if ("monitoringIntervalInSeconds".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties
                        .withMonitoringIntervalInSeconds(reader.getNullable(JsonReader::getInt));
                } else if ("endpoints".equals(fieldName)) {
                    List<ConnectionMonitorEndpoint> endpoints
                        = reader.readArray(reader1 -> ConnectionMonitorEndpoint.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withEndpoints(endpoints);
                } else if ("testConfigurations".equals(fieldName)) {
                    List<ConnectionMonitorTestConfiguration> testConfigurations
                        = reader.readArray(reader1 -> ConnectionMonitorTestConfiguration.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withTestConfigurations(testConfigurations);
                } else if ("testGroups".equals(fieldName)) {
                    List<ConnectionMonitorTestGroup> testGroups
                        = reader.readArray(reader1 -> ConnectionMonitorTestGroup.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withTestGroups(testGroups);
                } else if ("outputs".equals(fieldName)) {
                    List<ConnectionMonitorOutput> outputs
                        = reader.readArray(reader1 -> ConnectionMonitorOutput.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withOutputs(outputs);
                } else if ("notes".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withNotes(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("monitoringStatus".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.monitoringStatus = reader.getString();
                } else if ("connectionMonitorType".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.connectionMonitorType
                        = ConnectionMonitorType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorResultProperties;
        });
    }
}
