// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.BgpCommunity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Service Community Properties.
 */
@Fluent
public final class BgpServiceCommunityInner extends Resource {
    /*
     * Properties of the BGP service community.
     */
    private BgpServiceCommunityPropertiesFormat innerProperties;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of BgpServiceCommunityInner class.
     */
    public BgpServiceCommunityInner() {
    }

    /**
     * Get the innerProperties property: Properties of the BGP service community.
     * 
     * @return the innerProperties value.
     */
    private BgpServiceCommunityPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the BgpServiceCommunityInner object itself.
     */
    public BgpServiceCommunityInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BgpServiceCommunityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BgpServiceCommunityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the serviceName property: The name of the bgp community. e.g. Skype.
     * 
     * @return the serviceName value.
     */
    public String serviceName() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceName();
    }

    /**
     * Set the serviceName property: The name of the bgp community. e.g. Skype.
     * 
     * @param serviceName the serviceName value to set.
     * @return the BgpServiceCommunityInner object itself.
     */
    public BgpServiceCommunityInner withServiceName(String serviceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpServiceCommunityPropertiesFormat();
        }
        this.innerProperties().withServiceName(serviceName);
        return this;
    }

    /**
     * Get the bgpCommunities property: A list of bgp communities.
     * 
     * @return the bgpCommunities value.
     */
    public List<BgpCommunity> bgpCommunities() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpCommunities();
    }

    /**
     * Set the bgpCommunities property: A list of bgp communities.
     * 
     * @param bgpCommunities the bgpCommunities value to set.
     * @return the BgpServiceCommunityInner object itself.
     */
    public BgpServiceCommunityInner withBgpCommunities(List<BgpCommunity> bgpCommunities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpServiceCommunityPropertiesFormat();
        }
        this.innerProperties().withBgpCommunities(bgpCommunities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpServiceCommunityInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpServiceCommunityInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BgpServiceCommunityInner.
     */
    public static BgpServiceCommunityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpServiceCommunityInner deserializedBgpServiceCommunityInner = new BgpServiceCommunityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBgpServiceCommunityInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.innerProperties
                        = BgpServiceCommunityPropertiesFormat.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedBgpServiceCommunityInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpServiceCommunityInner;
        });
    }
}
