// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.BastionConnectProtocol;
import java.io.IOException;

/**
 * The session detail for a target.
 */
@Immutable
public final class BastionActiveSessionInner implements JsonSerializable<BastionActiveSessionInner> {
    /*
     * A unique id for the session.
     */
    private String sessionId;

    /*
     * The time when the session started.
     */
    private Object startTime;

    /*
     * The subscription id for the target virtual machine.
     */
    private String targetSubscriptionId;

    /*
     * The type of the resource.
     */
    private String resourceType;

    /*
     * The host name of the target.
     */
    private String targetHostname;

    /*
     * The resource group of the target.
     */
    private String targetResourceGroup;

    /*
     * The user name who is active on this session.
     */
    private String username;

    /*
     * The IP Address of the target.
     */
    private String targetIpAddress;

    /*
     * The protocol used to connect to the target.
     */
    private BastionConnectProtocol protocol;

    /*
     * The resource id of the target.
     */
    private String targetResourceId;

    /*
     * Duration in mins the session has been active.
     */
    private Float sessionDurationInMins;

    /**
     * Creates an instance of BastionActiveSessionInner class.
     */
    public BastionActiveSessionInner() {
    }

    /**
     * Get the sessionId property: A unique id for the session.
     * 
     * @return the sessionId value.
     */
    public String sessionId() {
        return this.sessionId;
    }

    /**
     * Get the startTime property: The time when the session started.
     * 
     * @return the startTime value.
     */
    public Object startTime() {
        return this.startTime;
    }

    /**
     * Get the targetSubscriptionId property: The subscription id for the target virtual machine.
     * 
     * @return the targetSubscriptionId value.
     */
    public String targetSubscriptionId() {
        return this.targetSubscriptionId;
    }

    /**
     * Get the resourceType property: The type of the resource.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the targetHostname property: The host name of the target.
     * 
     * @return the targetHostname value.
     */
    public String targetHostname() {
        return this.targetHostname;
    }

    /**
     * Get the targetResourceGroup property: The resource group of the target.
     * 
     * @return the targetResourceGroup value.
     */
    public String targetResourceGroup() {
        return this.targetResourceGroup;
    }

    /**
     * Get the username property: The user name who is active on this session.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Get the targetIpAddress property: The IP Address of the target.
     * 
     * @return the targetIpAddress value.
     */
    public String targetIpAddress() {
        return this.targetIpAddress;
    }

    /**
     * Get the protocol property: The protocol used to connect to the target.
     * 
     * @return the protocol value.
     */
    public BastionConnectProtocol protocol() {
        return this.protocol;
    }

    /**
     * Get the targetResourceId property: The resource id of the target.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Get the sessionDurationInMins property: Duration in mins the session has been active.
     * 
     * @return the sessionDurationInMins value.
     */
    public Float sessionDurationInMins() {
        return this.sessionDurationInMins;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BastionActiveSessionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BastionActiveSessionInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BastionActiveSessionInner.
     */
    public static BastionActiveSessionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BastionActiveSessionInner deserializedBastionActiveSessionInner = new BastionActiveSessionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sessionId".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.sessionId = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.startTime = reader.readUntyped();
                } else if ("targetSubscriptionId".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.targetSubscriptionId = reader.getString();
                } else if ("resourceType".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.resourceType = reader.getString();
                } else if ("targetHostName".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.targetHostname = reader.getString();
                } else if ("targetResourceGroup".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.targetResourceGroup = reader.getString();
                } else if ("userName".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.username = reader.getString();
                } else if ("targetIpAddress".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.targetIpAddress = reader.getString();
                } else if ("protocol".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.protocol
                        = BastionConnectProtocol.fromString(reader.getString());
                } else if ("targetResourceId".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.targetResourceId = reader.getString();
                } else if ("sessionDurationInMins".equals(fieldName)) {
                    deserializedBastionActiveSessionInner.sessionDurationInMins
                        = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBastionActiveSessionInner;
        });
    }
}
