// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * SSL certificates of an application gateway.
 */
@Fluent
public final class ApplicationGatewaySslCertificateInner extends SubResource {
    /*
     * Properties of the application gateway SSL certificate.
     */
    private ApplicationGatewaySslCertificatePropertiesFormat innerProperties;

    /*
     * Name of the SSL certificate that is unique within an Application Gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewaySslCertificateInner class.
     */
    public ApplicationGatewaySslCertificateInner() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway SSL certificate.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewaySslCertificatePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the SSL certificate that is unique within an Application Gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the SSL certificate that is unique within an Application Gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewaySslCertificateInner object itself.
     */
    public ApplicationGatewaySslCertificateInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewaySslCertificateInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the data property: Base-64 encoded pfx certificate. Only applicable in PUT Request.
     * 
     * @return the data value.
     */
    public String data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    /**
     * Set the data property: Base-64 encoded pfx certificate. Only applicable in PUT Request.
     * 
     * @param data the data value to set.
     * @return the ApplicationGatewaySslCertificateInner object itself.
     */
    public ApplicationGatewaySslCertificateInner withData(String data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslCertificatePropertiesFormat();
        }
        this.innerProperties().withData(data);
        return this;
    }

    /**
     * Get the password property: Password for the pfx file specified in data. Only applicable in PUT request.
     * 
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: Password for the pfx file specified in data. Only applicable in PUT request.
     * 
     * @param password the password value to set.
     * @return the ApplicationGatewaySslCertificateInner object itself.
     */
    public ApplicationGatewaySslCertificateInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslCertificatePropertiesFormat();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the publicCertData property: Base-64 encoded Public cert data corresponding to pfx specified in data. Only
     * applicable in GET request.
     * 
     * @return the publicCertData value.
     */
    public String publicCertData() {
        return this.innerProperties() == null ? null : this.innerProperties().publicCertData();
    }

    /**
     * Get the keyVaultSecretId property: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate'
     * object stored in KeyVault.
     * 
     * @return the keyVaultSecretId value.
     */
    public String keyVaultSecretId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretId();
    }

    /**
     * Set the keyVaultSecretId property: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate'
     * object stored in KeyVault.
     * 
     * @param keyVaultSecretId the keyVaultSecretId value to set.
     * @return the ApplicationGatewaySslCertificateInner object itself.
     */
    public ApplicationGatewaySslCertificateInner withKeyVaultSecretId(String keyVaultSecretId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslCertificatePropertiesFormat();
        }
        this.innerProperties().withKeyVaultSecretId(keyVaultSecretId);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the SSL certificate resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewaySslCertificateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewaySslCertificateInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewaySslCertificateInner.
     */
    public static ApplicationGatewaySslCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewaySslCertificateInner deserializedApplicationGatewaySslCertificateInner
                = new ApplicationGatewaySslCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewaySslCertificateInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewaySslCertificateInner.innerProperties
                        = ApplicationGatewaySslCertificatePropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewaySslCertificateInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewaySslCertificateInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewaySslCertificateInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewaySslCertificateInner;
        });
    }
}
