/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.fluent.models.AdminPropertiesFormat;
import com.azure.resourcemanager.network.models.ActiveBaseSecurityAdminRule;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.ConfigurationGroup;
import com.azure.resourcemanager.network.models.EffectiveAdminRuleKind;
import com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="kind", defaultImpl=ActiveSecurityAdminRule.class, visible=true)
@JsonTypeName(value="Custom")
public final class ActiveSecurityAdminRule
extends ActiveBaseSecurityAdminRule {
    @JsonTypeId
    @JsonProperty(value="kind", required=true)
    private EffectiveAdminRuleKind kind = EffectiveAdminRuleKind.CUSTOM;
    @JsonProperty(value="properties")
    private AdminPropertiesFormat innerProperties;

    @Override
    public EffectiveAdminRuleKind kind() {
        return this.kind;
    }

    private AdminPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ActiveSecurityAdminRule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withCommitTime(OffsetDateTime commitTime) {
        super.withCommitTime(commitTime);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withRegion(String region) {
        super.withRegion(region);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withConfigurationDescription(String configurationDescription) {
        super.withConfigurationDescription(configurationDescription);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withRuleCollectionDescription(String ruleCollectionDescription) {
        super.withRuleCollectionDescription(ruleCollectionDescription);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withRuleCollectionAppliesToGroups(List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups) {
        super.withRuleCollectionAppliesToGroups(ruleCollectionAppliesToGroups);
        return this;
    }

    @Override
    public ActiveSecurityAdminRule withRuleGroups(List<ConfigurationGroup> ruleGroups) {
        super.withRuleGroups(ruleGroups);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ActiveSecurityAdminRule withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public ActiveSecurityAdminRule withProtocol(SecurityConfigurationRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    public ActiveSecurityAdminRule withSources(List<AddressPrefixItem> sources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSources(sources);
        return this;
    }

    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public ActiveSecurityAdminRule withDestinations(List<AddressPrefixItem> destinations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinations(destinations);
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public ActiveSecurityAdminRule withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public ActiveSecurityAdminRule withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public ActiveSecurityAdminRule withAccess(SecurityConfigurationRuleAccess access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().priority());
    }

    public ActiveSecurityAdminRule withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public ActiveSecurityAdminRule withDirection(SecurityConfigurationRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

