// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Set this property to Tenant to allow sharing subnet with other subscriptions in your AAD tenant. This property can
 * only be set if defaultOutboundAccess is set to false, both properties can only be set if subnet is empty.
 */
public final class SharingScope extends ExpandableStringEnum<SharingScope> {
    /**
     * Static value Tenant for SharingScope.
     */
    public static final SharingScope TENANT = fromString("Tenant");

    /**
     * Static value DelegatedServices for SharingScope.
     */
    public static final SharingScope DELEGATED_SERVICES = fromString("DelegatedServices");

    /**
     * Creates a new instance of SharingScope value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SharingScope() {
    }

    /**
     * Creates or finds a SharingScope from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SharingScope.
     */
    @JsonCreator
    public static SharingScope fromString(String name) {
        return fromString(name, SharingScope.class);
    }

    /**
     * Gets known SharingScope values.
     * 
     * @return known SharingScope values.
     */
    public static Collection<SharingScope> values() {
        return values(SharingScope.class);
    }
}
