// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Defines a managed rule group to use for exclusion.
 */
@Fluent
public final class ExclusionManagedRuleGroup {
    /*
     * The managed rule group for exclusion.
     */
    @JsonProperty(value = "ruleGroupName", required = true)
    private String ruleGroupName;

    /*
     * List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    @JsonProperty(value = "rules")
    private List<ExclusionManagedRule> rules;

    /**
     * Creates an instance of ExclusionManagedRuleGroup class.
     */
    public ExclusionManagedRuleGroup() {
    }

    /**
     * Get the ruleGroupName property: The managed rule group for exclusion.
     * 
     * @return the ruleGroupName value.
     */
    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    /**
     * Set the ruleGroupName property: The managed rule group for exclusion.
     * 
     * @param ruleGroupName the ruleGroupName value to set.
     * @return the ExclusionManagedRuleGroup object itself.
     */
    public ExclusionManagedRuleGroup withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    /**
     * Get the rules property: List of rules that will be excluded. If none specified, all rules in the group will be
     * excluded.
     * 
     * @return the rules value.
     */
    public List<ExclusionManagedRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of rules that will be excluded. If none specified, all rules in the group will be
     * excluded.
     * 
     * @param rules the rules value to set.
     * @return the ExclusionManagedRuleGroup object itself.
     */
    public ExclusionManagedRuleGroup withRules(List<ExclusionManagedRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleGroupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleGroupName in model ExclusionManagedRuleGroup"));
        }
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExclusionManagedRuleGroup.class);
}
