// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Describes the connection monitor test group.
 */
@Fluent
public final class ConnectionMonitorTestGroup {
    /*
     * The name of the connection monitor test group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Value indicating whether test group is disabled.
     */
    @JsonProperty(value = "disable")
    private Boolean disable;

    /*
     * List of test configuration names.
     */
    @JsonProperty(value = "testConfigurations", required = true)
    private List<String> testConfigurations;

    /*
     * List of source endpoint names.
     */
    @JsonProperty(value = "sources", required = true)
    private List<String> sources;

    /*
     * List of destination endpoint names.
     */
    @JsonProperty(value = "destinations", required = true)
    private List<String> destinations;

    /**
     * Creates an instance of ConnectionMonitorTestGroup class.
     */
    public ConnectionMonitorTestGroup() {
    }

    /**
     * Get the name property: The name of the connection monitor test group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the connection monitor test group.
     * 
     * @param name the name value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the disable property: Value indicating whether test group is disabled.
     * 
     * @return the disable value.
     */
    public Boolean disable() {
        return this.disable;
    }

    /**
     * Set the disable property: Value indicating whether test group is disabled.
     * 
     * @param disable the disable value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    /**
     * Get the testConfigurations property: List of test configuration names.
     * 
     * @return the testConfigurations value.
     */
    public List<String> testConfigurations() {
        return this.testConfigurations;
    }

    /**
     * Set the testConfigurations property: List of test configuration names.
     * 
     * @param testConfigurations the testConfigurations value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withTestConfigurations(List<String> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    /**
     * Get the sources property: List of source endpoint names.
     * 
     * @return the sources value.
     */
    public List<String> sources() {
        return this.sources;
    }

    /**
     * Set the sources property: List of source endpoint names.
     * 
     * @param sources the sources value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    /**
     * Get the destinations property: List of destination endpoint names.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of destination endpoint names.
     * 
     * @param destinations the destinations value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property name in model ConnectionMonitorTestGroup"));
        }
        if (testConfigurations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property testConfigurations in model ConnectionMonitorTestGroup"));
        }
        if (sources() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sources in model ConnectionMonitorTestGroup"));
        }
        if (destinations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinations in model ConnectionMonitorTestGroup"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorTestGroup.class);
}
