// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Header configuration of the Actions set in Application Gateway.
 */
@Fluent
public final class ApplicationGatewayHeaderConfiguration {
    /*
     * Header name of the header configuration.
     */
    @JsonProperty(value = "headerName")
    private String headerName;

    /*
     * An optional field under "Rewrite Action". It lets you capture and modify the value(s) of a specific header when
     * multiple headers with the same name exist. Currently supported for Set-Cookie Response header only. For more
     * details, visit https://aka.ms/appgwheadercrud
     */
    @JsonProperty(value = "headerValueMatcher")
    private HeaderValueMatcher headerValueMatcher;

    /*
     * Header value of the header configuration.
     */
    @JsonProperty(value = "headerValue")
    private String headerValue;

    /**
     * Creates an instance of ApplicationGatewayHeaderConfiguration class.
     */
    public ApplicationGatewayHeaderConfiguration() {
    }

    /**
     * Get the headerName property: Header name of the header configuration.
     * 
     * @return the headerName value.
     */
    public String headerName() {
        return this.headerName;
    }

    /**
     * Set the headerName property: Header name of the header configuration.
     * 
     * @param headerName the headerName value to set.
     * @return the ApplicationGatewayHeaderConfiguration object itself.
     */
    public ApplicationGatewayHeaderConfiguration withHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    /**
     * Get the headerValueMatcher property: An optional field under "Rewrite Action". It lets you capture and modify the
     * value(s) of a specific header when multiple headers with the same name exist. Currently supported for Set-Cookie
     * Response header only. For more details, visit https://aka.ms/appgwheadercrud.
     * 
     * @return the headerValueMatcher value.
     */
    public HeaderValueMatcher headerValueMatcher() {
        return this.headerValueMatcher;
    }

    /**
     * Set the headerValueMatcher property: An optional field under "Rewrite Action". It lets you capture and modify the
     * value(s) of a specific header when multiple headers with the same name exist. Currently supported for Set-Cookie
     * Response header only. For more details, visit https://aka.ms/appgwheadercrud.
     * 
     * @param headerValueMatcher the headerValueMatcher value to set.
     * @return the ApplicationGatewayHeaderConfiguration object itself.
     */
    public ApplicationGatewayHeaderConfiguration withHeaderValueMatcher(HeaderValueMatcher headerValueMatcher) {
        this.headerValueMatcher = headerValueMatcher;
        return this;
    }

    /**
     * Get the headerValue property: Header value of the header configuration.
     * 
     * @return the headerValue value.
     */
    public String headerValue() {
        return this.headerValue;
    }

    /**
     * Set the headerValue property: Header value of the header configuration.
     * 
     * @param headerValue the headerValue value to set.
     * @return the ApplicationGatewayHeaderConfiguration object itself.
     */
    public ApplicationGatewayHeaderConfiguration withHeaderValue(String headerValue) {
        this.headerValue = headerValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (headerValueMatcher() != null) {
            headerValueMatcher().validate();
        }
    }
}
