// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.BaseAdminRuleInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * security configuration admin rule list result.
 */
@Fluent
public final class AdminRuleListResult {
    /*
     * A list of admin rules
     */
    @JsonProperty(value = "value")
    private List<BaseAdminRuleInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of AdminRuleListResult class.
     */
    public AdminRuleListResult() {
    }

    /**
     * Get the value property: A list of admin rules.
     * 
     * @return the value value.
     */
    public List<BaseAdminRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of admin rules.
     * 
     * @param value the value value to set.
     * @return the AdminRuleListResult object itself.
     */
    public AdminRuleListResult withValue(List<BaseAdminRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AdminRuleListResult object itself.
     */
    public AdminRuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
