// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRuleType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of routing rule of the application gateway.
 */
@Fluent
public final class ApplicationGatewayRoutingRulePropertiesFormat {
    /*
     * Rule type.
     */
    @JsonProperty(value = "ruleType")
    private ApplicationGatewayRequestRoutingRuleType ruleType;

    /*
     * Priority of the routing rule.
     */
    @JsonProperty(value = "priority", required = true)
    private int priority;

    /*
     * Backend address pool resource of the application gateway.
     */
    @JsonProperty(value = "backendAddressPool")
    private SubResource backendAddressPool;

    /*
     * Backend settings resource of the application gateway.
     */
    @JsonProperty(value = "backendSettings")
    private SubResource backendSettings;

    /*
     * Listener resource of the application gateway.
     */
    @JsonProperty(value = "listener")
    private SubResource listener;

    /*
     * The provisioning state of the request routing rule resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayRoutingRulePropertiesFormat class.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat() {
    }

    /**
     * Get the ruleType property: Rule type.
     * 
     * @return the ruleType value.
     */
    public ApplicationGatewayRequestRoutingRuleType ruleType() {
        return this.ruleType;
    }

    /**
     * Set the ruleType property: Rule type.
     * 
     * @param ruleType the ruleType value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat
        withRuleType(ApplicationGatewayRequestRoutingRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    /**
     * Get the priority property: Priority of the routing rule.
     * 
     * @return the priority value.
     */
    public int priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority of the routing rule.
     * 
     * @param priority the priority value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendSettings property: Backend settings resource of the application gateway.
     * 
     * @return the backendSettings value.
     */
    public SubResource backendSettings() {
        return this.backendSettings;
    }

    /**
     * Set the backendSettings property: Backend settings resource of the application gateway.
     * 
     * @param backendSettings the backendSettings value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withBackendSettings(SubResource backendSettings) {
        this.backendSettings = backendSettings;
        return this;
    }

    /**
     * Get the listener property: Listener resource of the application gateway.
     * 
     * @return the listener value.
     */
    public SubResource listener() {
        return this.listener;
    }

    /**
     * Set the listener property: Listener resource of the application gateway.
     * 
     * @param listener the listener value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withListener(SubResource listener) {
        this.listener = listener;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the request routing rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
