/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ManagementGroupNetworkManagerConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerConnectionInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NetworkManagerConnectionListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

public final class ManagementGroupNetworkManagerConnectionsClientImpl
implements InnerSupportsDelete<Void>,
ManagementGroupNetworkManagerConnectionsClient {
    private final ManagementGroupNetworkManagerConnectionsService service;
    private final NetworkManagementClientImpl client;

    ManagementGroupNetworkManagerConnectionsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ManagementGroupNetworkManagerConnectionsService)RestProxy.create(ManagementGroupNetworkManagerConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkManagerConnectionInner>> createOrUpdateWithResponseAsync(String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkManagerConnectionInner>> createOrUpdateWithResponseAsync(String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkManagerConnectionInner> createOrUpdateAsync(String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters) {
        return this.createOrUpdateWithResponseAsync(managementGroupId, networkManagerConnectionName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkManagerConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkManagerConnectionInner> createOrUpdateWithResponse(String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(managementGroupId, networkManagerConnectionName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkManagerConnectionInner createOrUpdate(String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters) {
        return (NetworkManagerConnectionInner)((Object)this.createOrUpdateWithResponse(managementGroupId, networkManagerConnectionName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkManagerConnectionInner>> getWithResponseAsync(String managementGroupId, String networkManagerConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkManagerConnectionInner>> getWithResponseAsync(String managementGroupId, String networkManagerConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkManagerConnectionInner> getAsync(String managementGroupId, String networkManagerConnectionName) {
        return this.getWithResponseAsync(managementGroupId, networkManagerConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkManagerConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkManagerConnectionInner> getWithResponse(String managementGroupId, String networkManagerConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(managementGroupId, networkManagerConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkManagerConnectionInner get(String managementGroupId, String networkManagerConnectionName) {
        return (NetworkManagerConnectionInner)((Object)this.getWithResponse(managementGroupId, networkManagerConnectionName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String managementGroupId, String networkManagerConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String managementGroupId, String networkManagerConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (networkManagerConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerConnectionName is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), managementGroupId, networkManagerConnectionName, "2023-11-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String managementGroupId, String networkManagerConnectionName) {
        return this.deleteWithResponseAsync(managementGroupId, networkManagerConnectionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String managementGroupId, String networkManagerConnectionName, Context context) {
        return (Response)this.deleteWithResponseAsync(managementGroupId, networkManagerConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String managementGroupId, String networkManagerConnectionName) {
        this.deleteWithResponse(managementGroupId, networkManagerConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkManagerConnectionInner>> listSinglePageAsync(String managementGroupId, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), managementGroupId, "2023-11-01", top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkManagerConnectionListResult)res.getValue()).value(), ((NetworkManagerConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkManagerConnectionInner>> listSinglePageAsync(String managementGroupId, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2023-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), managementGroupId, "2023-11-01", top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkManagerConnectionListResult)res.getValue()).value(), ((NetworkManagerConnectionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkManagerConnectionInner> listAsync(String managementGroupId, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(managementGroupId, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkManagerConnectionInner> listAsync(String managementGroupId) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(managementGroupId, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkManagerConnectionInner> listAsync(String managementGroupId, Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(managementGroupId, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkManagerConnectionInner> list(String managementGroupId) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(managementGroupId, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkManagerConnectionInner> list(String managementGroupId, Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(managementGroupId, top, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkManagerConnectionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkManagerConnectionListResult)res.getValue()).value(), ((NetworkManagerConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkManagerConnectionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkManagerConnectionListResult)res.getValue()).value(), ((NetworkManagerConnectionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface ManagementGroupNetworkManagerConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkManagerConnectionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="networkManagerConnectionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") NetworkManagerConnectionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkManagerConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="networkManagerConnectionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="networkManagerConnectionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Network/networkManagerConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkManagerConnectionListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$skipToken") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkManagerConnectionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

